"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../../shared_components");
var _suggestion_helpers = require("../../suggestion_helpers");
var _lens_ui_errors = require("../../../../lens_ui_errors");
var _state_management = require("../../../../state_management");
var _id_generator = require("../../../../id_generator/id_generator");
var _chart_switch_selectable = require("./chart_switch_selectable");
var _chart_option = require("./chart_option");
var _editor_frame_service_context = require("../../../editor_frame_service_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/config_panel/chart_switch/chart_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortByPriority = (a, b) => {
  return a.sortPriority - b.sortPriority;
};
const deprecatedGroupChartSwitchElement = {
  key: 'deprecated',
  value: 'deprecated',
  label: _i18n.i18n.translate('xpack.lens.configPanel.deprecated', {
    defaultMessage: 'Deprecated'
  }),
  isGroupLabel: true,
  'aria-label': 'deprecated',
  'data-test-subj': `lnsChartSwitchPopover_deprecated`
};
function safeFnCall(action, defaultReturnValue) {
  try {
    return action();
  } catch (error) {
    (0, _lens_ui_errors.showMemoizedErrorNotification)(error);
    return defaultReturnValue;
  }
}
const ChartSwitch = exports.ChartSwitch = /*#__PURE__*/(0, _react.memo)(function ChartSwitch({
  filteredVisualizationMap,
  framePublicAPI,
  layerId,
  onChartSelect
}) {
  const visualizationMap = filteredVisualizationMap;
  const {
    datasourceMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const commitSelection = selection => {
    (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, {
      ...selection,
      visualizationState: selection.getVisualizationState()
    }, {
      clearStagedPreview: true
    });
    if (!selection.datasourceId && !selection.sameDatasources || selection.dataLoss === 'everything') {
      dispatchLens((0, _state_management.removeLayers)({
        visualizationId: visualization.activeId,
        layerIds: Object.keys(framePublicAPI.datasourceLayers)
      }));
    }
  };
  function getSelection(visualizationId, subVisualizationId) {
    const newVisualization = visualizationMap[visualizationId];
    const switchVisType = (type, state, lId) => {
      if (visualizationMap[visualizationId].switchVisualizationType) {
        return safeFnCall(() => visualizationMap[visualizationId].switchVisualizationType(type, state, lId), state);
      }
      return state;
    };
    const layers = Object.entries(framePublicAPI.datasourceLayers);

    // Always show the active visualization as a valid selection
    if (visualization.activeId === visualizationId && visualization.state && safeFnCall(() => {
      var _newVisualization$isS;
      return newVisualization.getVisualizationTypeId(visualization.state) === subVisualizationId || ((_newVisualization$isS = newVisualization.isSubtypeCompatible) === null || _newVisualization$isS === void 0 ? void 0 : _newVisualization$isS.call(newVisualization, newVisualization.getVisualizationTypeId(visualization.state), subVisualizationId));
    }, false)) {
      return {
        visualizationId,
        subVisualizationId,
        dataLoss: 'nothing',
        keptLayerIds: Object.keys(framePublicAPI.datasourceLayers),
        getVisualizationState: () => switchVisType(subVisualizationId, visualization.state, layerId),
        sameDatasources: true
      };
    }
    const topSuggestion = getTopSuggestion(visualizationMap, datasourceMap, framePublicAPI, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId, layerId);
    const dataLoss = getDataLoss(layers, topSuggestion);
    function addNewLayer() {
      const newLayerId = (0, _id_generator.generateId)();
      dispatchLens((0, _state_management.insertLayer)({
        datasourceId: activeDatasourceId,
        layerId: newLayerId
      }));
      return newLayerId;
    }
    return {
      visualizationId,
      subVisualizationId,
      dataLoss,
      getVisualizationState: topSuggestion ? () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, topSuggestion.visualizationState), layerId) : () => switchVisType(subVisualizationId, newVisualization.initialize(addNewLayer, visualization.activeId === newVisualization.id ? visualization.state : undefined, visualization.activeId && visualizationMap[visualization.activeId].getMainPalette ? visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined), layerId),
      keptLayerIds: topSuggestion ? topSuggestion.keptLayerIds : [],
      datasourceState: topSuggestion ? topSuggestion.datasourceState : undefined,
      datasourceId: topSuggestion ? topSuggestion.datasourceId : undefined,
      sameDatasources: dataLoss === 'nothing' && visualization.activeId === newVisualization.id
    };
  }
  const {
    visualizationTypes,
    visualizationsLookup
  } = (0, _react.useMemo)(() => {
    const subVisualizationId = visualization.activeId && visualizationMap[visualization.activeId] ? getVisualizationTypeId(visualizationMap[visualization.activeId], visualization.state, layerId) : undefined;
    const lowercasedSearchTerm = searchTerm.toLowerCase();

    // Will need it later on to quickly pick up the metadata from it
    const lookup = {};
    const chartSwitchPositions = [];
    const deprecatedChartSwitchPositions = [];
    Object.entries(visualizationMap).forEach(([visualizationId, v]) => {
      const chartSwitchOptions = v.visualizationTypes;
      for (const visualizationType of chartSwitchOptions) {
        var _visualizationType$de;
        const isSearchMatch = visualizationType.label.toLowerCase().includes(lowercasedSearchTerm) || ((_visualizationType$de = visualizationType.description) === null || _visualizationType$de === void 0 ? void 0 : _visualizationType$de.toLowerCase().includes(lowercasedSearchTerm));
        if (isSearchMatch) {
          const subtypeId = findSubtypeId(visualizationType, subVisualizationId);
          const visualizationEntry = {
            ...visualizationType,
            visualizationId,
            selection: getSelection(visualizationId, subtypeId)
          };
          if (visualizationEntry.isDeprecated) {
            deprecatedChartSwitchPositions.push(visualizationEntry);
          } else {
            chartSwitchPositions.push(visualizationEntry);
          }
          lookup[`${visualizationId}:${visualizationType.id}`] = visualizationEntry;
        }
      }
    });
    const toSelectableEntry = v => {
      const isChecked = subVisualizationId === v.id;
      return {
        'aria-label': v.label,
        className: 'lnsChartSwitch__option',
        key: `${v.visualizationId}:${v.id}`,
        // todo: should we simplify?
        value: `${v.visualizationId}:${v.id}`,
        'data-test-subj': `lnsChartSwitchPopover_${v.id}`,
        label: v.label,
        prepend: /*#__PURE__*/_react.default.createElement(_chart_option.ChartSwitchOptionPrepend, {
          isChecked: isChecked,
          dataLoss: v.selection.dataLoss,
          subtypeId: v.selection.subVisualizationId,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 277,
            columnNumber: 13
          }
        }),
        data: {
          description: v.description,
          icon: v.icon
        },
        append: v.showExperimentalBadge ? /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 45
          }
        }) : null,
        // Apparently checked: null is not valid for TS
        ...(isChecked && {
          checked: 'on'
        })
      };
    };
    return {
      visualizationTypes: chartSwitchPositions.sort(sortByPriority).map(toSelectableEntry).concat(deprecatedChartSwitchPositions.length ? [deprecatedGroupChartSwitchElement, ...deprecatedChartSwitchPositions.map(toSelectableEntry)] : []),
      visualizationsLookup: lookup
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [visualizationMap, framePublicAPI, visualization.activeId, visualization.state, searchTerm]);
  return /*#__PURE__*/_react.default.createElement(_chart_switch_selectable.ChartSwitchSelectable, {
    searchable: true,
    options: visualizationTypes,
    onChange: newOptions => {
      onChartSelect();
      const chosenType = newOptions.find(({
        checked
      }) => checked === 'on');
      if (!chosenType || !chosenType.value) {
        return;
      }
      const id = chosenType.value;
      commitSelection(visualizationsLookup[id].selection);
    },
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 5
    }
  });
});
const getVisualizationSubtypes = (visualization, state, layerId) => {
  const typeId = safeFnCall(() => visualization.getVisualizationTypeId(state, layerId), undefined);
  const type = visualization.visualizationTypes.find(t => t.id === typeId);
  if (type !== null && type !== void 0 && type.subtypes) {
    return type.subtypes;
  }
  return [typeId];
};
const getVisualizationTypeId = (activeVisualization, visualizationState, layerId) => safeFnCall(() => activeVisualization.getVisualizationTypeId(visualizationState, layerId), undefined);
const findSubtypeId = (visType, subtypeId) => {
  if (visType.subtypes) {
    var _visType$getCompatibl;
    return visType.subtypes.find(subtype => subtype === subtypeId) || ((_visType$getCompatibl = visType.getCompatibleSubtype) === null || _visType$getCompatibl === void 0 ? void 0 : _visType$getCompatibl.call(visType, subtypeId)) || visType.subtypes[0];
  }
  return visType.id;
};
function getTopSuggestion(visualizationMap, datasourceMap, framePublicAPI, visualizationId, datasourceStates, visualization, newVisualization, subVisualizationId, layerId) {
  const mainPalette = visualization.activeId && visualizationMap[visualization.activeId] && visualizationMap[visualization.activeId].getMainPalette ? visualizationMap[visualization.activeId].getMainPalette(visualization.state) : undefined;
  const unfilteredSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates,
    visualizationMap: {
      [visualizationId]: newVisualization
    },
    activeVisualization: visualization.activeId ? visualizationMap[visualization.activeId] : undefined,
    visualizationState: visualization.state,
    subVisualizationId,
    activeData: framePublicAPI.activeData,
    mainPalette,
    dataViews: framePublicAPI.dataViews
  });
  const suggestions = unfilteredSuggestions.filter(suggestion => {
    // don't use extended versions of current data table on switching between visualizations
    // to avoid confusing the user.

    const subtypes = getVisualizationSubtypes(newVisualization, suggestion.visualizationState);
    return suggestion.changeType !== 'extended' && subtypes.includes(subVisualizationId);
  });
  return suggestions.find(s => s.changeType === 'unchanged' || s.changeType === 'reduced') || suggestions.find(s => s.keptLayerIds.some(id => id === layerId)) || suggestions[0];
}
const getDataLoss = (layers, topSuggestion) => {
  var _layers$0$;
  const containsData = layers.some(([_layerId, datasource]) => datasource && datasource.getTableSpec().length > 0);
  if (!containsData) {
    return 'nothing';
  } else if (!topSuggestion) {
    return 'everything';
  } else if (layers.length > 1 && layers.length > topSuggestion.keptLayerIds.length) {
    return 'layers';
  } else if (topSuggestion.columns !== ((_layers$0$ = layers[0][1]) === null || _layers$0$ === void 0 ? void 0 : _layers$0$.getTableSpec().length)) {
    return 'columns';
  } else {
    return 'nothing';
  }
};