"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/shared_components/label_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LabelInput = ({
  value,
  onChange,
  placeholder,
  inputRef,
  onSubmit,
  dataTestSubj,
  compressed
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value,
    onChange
  }, {
    allowFalsyValue: true
  });
  const localKeyHold = (0, _react.useRef)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": dataTestSubj || 'lens-labelInput',
    value: inputValue,
    onChange: e => handleInputChange(e.target.value),
    fullWidth: true,
    placeholder: placeholder || '',
    inputRef: node => {
      if (inputRef && node) {
        inputRef.current = node;
      }
    },
    onKeyDown: () => {
      localKeyHold.current = true;
    },
    onKeyUp: ({
      key
    }) => {
      // only submit on key up in case the user started the keypress while the input was focused
      if (localKeyHold.current && _eui.keys.ENTER === key && onSubmit) {
        onSubmit();
      }
      localKeyHold.current = false;
    },
    prepend: _i18n.i18n.translate('xpack.lens.labelInput.label', {
      defaultMessage: 'Label'
    }),
    compressed: compressed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.LabelInput = LabelInput;