"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeShift = TimeShift;
exports.setTimeShift = setTimeShift;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _operations = require("../operations");
var _time_shift_utils = require("../time_shift_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/time_shift.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function setTimeShift(columnId, layer, timeShift) {
  const trimmedTimeShift = timeShift === null || timeShift === void 0 ? void 0 : timeShift.trim();
  const currentColumn = layer.columns[columnId];
  const label = currentColumn.customLabel ? currentColumn.label : (0, _operations.adjustTimeScaleLabelSuffix)(currentColumn.label, currentColumn.timeScale, currentColumn.timeScale, currentColumn.timeShift, trimmedTimeShift, currentColumn.reducedTimeRange, currentColumn.reducedTimeRange);
  return {
    ...layer,
    columns: {
      ...layer.columns,
      [columnId]: {
        ...layer.columns[columnId],
        label,
        timeShift: trimmedTimeShift
      }
    }
  };
}
function TimeShift({
  datatableUtilities,
  selectedColumn,
  columnId,
  layer,
  updateLayer,
  indexPattern,
  activeData,
  layerId
}) {
  var _warnings$;
  const [localValue, setLocalValue] = (0, _react.useState)(selectedColumn.timeShift);
  (0, _react.useEffect)(() => {
    setLocalValue(selectedColumn.timeShift);
  }, [selectedColumn.timeShift]);
  const selectedOperation = _operations.operationDefinitionMap[selectedColumn.operationType];
  if (!selectedOperation.shiftable) {
    return null;
  }
  const dateHistogramInterval = (0, _time_shift_utils.getDateHistogramInterval)(datatableUtilities, layer, indexPattern, activeData, layerId);
  const {
    canShift,
    isValueTooSmall,
    isValueNotMultiple,
    isInvalid
  } = (0, _time_shift_utils.getLayerTimeShiftChecks)(dateHistogramInterval);
  if (!canShift) {
    return null;
  }
  const parsedLocalValue = localValue && (0, _common.parseTimeShift)(localValue);
  const isLocalValueInvalid = Boolean(parsedLocalValue && isInvalid(parsedLocalValue));
  const warnings = (0, _time_shift_utils.getColumnTimeShiftWarnings)(dateHistogramInterval, localValue);
  const timeShiftLabel = _i18n.i18n.translate('xpack.lens.indexPattern.timeShift.label', {
    defaultMessage: 'Time shift'
  });
  function getSelectedOption() {
    const goodPick = _time_shift_utils.timeShiftOptions.filter(({
      value
    }) => value === localValue);
    if (goodPick.length > 0) return goodPick;
    return [{
      value: localValue !== null && localValue !== void 0 ? localValue : '',
      label: localValue !== null && localValue !== void 0 ? localValue : _i18n.i18n.translate('xpack.lens.timeShift.none', {
        defaultMessage: 'None'
      })
    }];
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    "data-test-subj": "indexPattern-dimension-time-shift-row",
    label: timeShiftLabel,
    helpText: _i18n.i18n.translate('xpack.lens.indexPattern.timeShift.help', {
      defaultMessage: 'Enter the time shift number and unit'
    }),
    error: (_warnings$ = warnings[0]) !== null && _warnings$ !== void 0 ? _warnings$ : isLocalValueInvalid && _i18n.i18n.translate('xpack.lens.indexPattern.timeShift.genericInvalidHelp', {
      defaultMessage: 'Time shift value is not valid.'
    }),
    isInvalid: Boolean(isLocalValueInvalid || warnings.length),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: true,
    "data-test-subj": "indexPattern-dimension-time-shift",
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.timeShiftPlaceholder', {
      defaultMessage: 'Type custom values (e.g. 8w)'
    }),
    options: _time_shift_utils.timeShiftOptions.filter(({
      value
    }) => {
      const parsedValue = (0, _common.parseTimeShift)(value);
      return parsedValue && !isValueTooSmall(parsedValue) && !isValueNotMultiple(parsedValue);
    }),
    selectedOptions: getSelectedOption(),
    singleSelection: {
      asPlainText: false
    },
    isInvalid: isLocalValueInvalid,
    onCreateOption: val => {
      const parsedVal = (0, _common.parseTimeShift)(val);
      if (!isInvalid(parsedVal)) {
        updateLayer(setTimeShift(columnId, layer, val));
      } else {
        setLocalValue(val);
      }
    },
    onChange: choices => {
      if (choices.length === 0 || choices.length && choices[0].value === '') {
        updateLayer(setTimeShift(columnId, layer, ''));
        setLocalValue('');
        return;
      }
      const choice = choices[0].value;
      const parsedVal = (0, _common.parseTimeShift)(choice);
      if (!isInvalid(parsedVal)) {
        updateLayer(setTimeShift(columnId, layer, choice));
      } else {
        setLocalValue(choice);
      }
    },
    "aria-label": timeShiftLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })))));
}