"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatatableColumn = getDatatableColumn;
exports.getFieldMetaFromDatatable = getFieldMetaFromDatatable;
exports.getFieldTypeFromDatatable = getFieldTypeFromDatatable;
exports.isNumericField = isNumericField;
exports.isNumericFieldForDatatable = isNumericFieldForDatatable;
var _transposeUtils = require("@kbn/transpose-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Make sure to specifically check for "top_hits" when looking for array values
 *
 * **Note**: use this utility function only at the expression level,
 * not before (i.e. to decide if a column in numeric in a configuration panel)
 */
function isLastValueWithoutArraySupport(meta) {
  var _meta$sourceParams, _meta$sourceParams2, _meta$sourceParams2$p, _meta$sourceParams2$p2;
  return ((_meta$sourceParams = meta.sourceParams) === null || _meta$sourceParams === void 0 ? void 0 : _meta$sourceParams.type) !== 'filtered_metric' || ((_meta$sourceParams2 = meta.sourceParams) === null || _meta$sourceParams2 === void 0 ? void 0 : (_meta$sourceParams2$p = _meta$sourceParams2.params) === null || _meta$sourceParams2$p === void 0 ? void 0 : (_meta$sourceParams2$p2 = _meta$sourceParams2$p.customMetric) === null || _meta$sourceParams2$p2 === void 0 ? void 0 : _meta$sourceParams2$p2.type) !== 'top_hits';
}

/**
 * Returns true for numerical fields
 *
 * Excludes the following types:
 *  - `range` - Stringified range
 *  - `multi_terms` - Multiple values
 *  - `filters` - Arbitrary label
 *  - Last value with array values
 *
 * **Note**: use this utility function only at the expression level,
 * not before (i.e. to decide if a column in numeric in a configuration panel)
 */
function isNumericField(meta) {
  var _meta$params, _meta$params2, _meta$sourceParams3;
  return (meta === null || meta === void 0 ? void 0 : meta.type) === 'number' && ((_meta$params = meta.params) === null || _meta$params === void 0 ? void 0 : _meta$params.id) !== 'range' && ((_meta$params2 = meta.params) === null || _meta$params2 === void 0 ? void 0 : _meta$params2.id) !== 'multi_terms' && ((_meta$sourceParams3 = meta.sourceParams) === null || _meta$sourceParams3 === void 0 ? void 0 : _meta$sourceParams3.type) !== 'filters' && isLastValueWithoutArraySupport(meta);
}
function getDatatableColumn(table, accessor) {
  return table === null || table === void 0 ? void 0 : table.columns.find(col => col.id === accessor || (0, _transposeUtils.getOriginalId)(col.id) === accessor);
}
function getFieldMetaFromDatatable(table, accessor) {
  var _getDatatableColumn;
  return (_getDatatableColumn = getDatatableColumn(table, accessor)) === null || _getDatatableColumn === void 0 ? void 0 : _getDatatableColumn.meta;
}
function getFieldTypeFromDatatable(table, accessor) {
  var _getFieldMetaFromData;
  return (_getFieldMetaFromData = getFieldMetaFromDatatable(table, accessor)) === null || _getFieldMetaFromData === void 0 ? void 0 : _getFieldMetaFromData.type;
}

/**
 * Returns true for numerical fields, excluding ranges
 *
 * **Note**: use this utility function only at the expression level,
 * not before (i.e. to decide if a column in numeric in a configuration panel)
 */
function isNumericFieldForDatatable(table, accessor) {
  const meta = getFieldMetaFromDatatable(table, accessor);
  return isNumericField(meta);
}