"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromUniqueCountLensStateToAPI = exports.fromUniqueCountAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromUniqueCountAPItoLensState = options => {
  const {
    field,
    format,
    empty_as_null
  } = options;
  return {
    operationType: 'unique_count',
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      format: (0, _format.fromFormatAPIToLensState)(format),
      emptyAsNull: empty_as_null
    }
  };
};
exports.fromUniqueCountAPItoLensState = fromUniqueCountAPItoLensState;
const fromUniqueCountLensStateToAPI = options => {
  const {
    sourceField,
    params
  } = options;
  const {
    format,
    emptyAsNull
  } = params || {};
  return {
    operation: 'unique_count',
    field: sourceField,
    empty_as_null: Boolean(emptyAsNull),
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...(format ? {
      format: (0, _format.fromFormatLensStateToAPI)(format)
    } : {})
  };
};
exports.fromUniqueCountLensStateToAPI = fromUniqueCountLensStateToAPI;