"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromLastValueLensStateToAPI = exports.fromLastValueAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromLastValueAPItoLensState = options => {
  const {
    field,
    format,
    sort_by,
    show_array_values
  } = options;
  return {
    operationType: 'last_value',
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      sortField: sort_by,
      showArrayValues: show_array_values,
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
};
exports.fromLastValueAPItoLensState = fromLastValueAPItoLensState;
const fromLastValueLensStateToAPI = options => {
  var _options$params;
  return {
    operation: 'last_value',
    field: options.sourceField,
    sort_by: options.params.sortField,
    show_array_values: options.params.showArrayValues,
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromLastValueLensStateToAPI = fromLastValueLensStateToAPI;