"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromFormulaLensStateToAPI = exports.fromFormulaAPItoLensState = void 0;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromFormulaAPItoLensState = options => {
  const {
    formula,
    format
  } = options;
  const {
    timeShift,
    ...sharedProps
  } = (0, _utils.getLensStateMetricSharedProps)(options);
  return {
    operationType: 'formula',
    ...sharedProps,
    references: [],
    params: {
      formula,
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
};
exports.fromFormulaAPItoLensState = fromFormulaAPItoLensState;
const fromFormulaLensStateToAPI = options => {
  var _options$params, _options$params2;
  return {
    operation: 'formula',
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.formula ? {
      formula: options.params.formula
    } : {
      formula: ''
    }),
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params2 = options.params) !== null && _options$params2 !== void 0 && _options$params2.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
};
exports.fromFormulaLensStateToAPI = fromFormulaLensStateToAPI;