"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromFiltersLensApiToLensState = fromFiltersLensApiToLensState;
exports.fromFiltersLensStateToAPI = fromFiltersLensStateToAPI;
var _filter = require("./filter");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromFiltersLensApiToLensState(options) {
  const {
    filters,
    label
  } = options;
  const {
    sourceField,
    ...shared
  } = (0, _utils.getLensStateBucketSharedProps)({
    label,
    field: ''
  });
  return {
    dataType: 'string',
    operationType: 'filters',
    ...shared,
    params: {
      filters: (filters !== null && filters !== void 0 ? filters : [] // do not propagate advanced filters within dimensions
      ).filter(filter => filter.filter.language != null).map(filter => {
        var _filter$label;
        return {
          input: filter.filter,
          label: (_filter$label = filter.label) !== null && _filter$label !== void 0 ? _filter$label : 'Filter'
        };
      })
    }
  };
}
function fromFiltersLensStateToAPI(column) {
  const {
    label
  } = (0, _utils.getLensAPIBucketSharedProps)({
    ...column,
    sourceField: ''
  });
  return {
    operation: 'filters',
    label,
    filters: column.params.filters.map(filter => {
      var _fromFilterLensStateT;
      return {
        filter: (_fromFilterLensStateT = (0, _filter.fromFilterLensStateToAPI)(filter.input)) !== null && _fromFilterLensStateT !== void 0 ? _fromFilterLensStateT : _filter.DEFAULT_FILTER,
        ...(filter.label !== 'Filter' ? {
          label: filter.label
        } : {})
      };
    })
  };
}