"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromBucketLensApiToLensState = fromBucketLensApiToLensState;
exports.fromBucketLensStateToAPI = fromBucketLensStateToAPI;
var _utils = require("./utils");
var _filters = require("./filters");
var _date_histogram = require("./date_histogram");
var _range = require("./range");
var _top_values = require("./top_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromBucketLensApiToLensState(options, columns) {
  if ((0, _utils.isAPIColumnOfType)('filters', options)) {
    return (0, _filters.fromFiltersLensApiToLensState)(options);
  }
  if ((0, _utils.isAPIColumnOfType)('date_histogram', options)) {
    return (0, _date_histogram.fromDateHistogramLensApiToLensState)(options);
  }
  if ((0, _utils.isAPIColumnOfType)('range', options) || (0, _utils.isAPIColumnOfType)('histogram', options)) {
    return (0, _range.fromRangeOrHistogramLensApiToLensState)(options);
  }
  if ((0, _utils.isAPIColumnOfType)('terms', options)) {
    const findByIndex = index => {
      var _columns$index;
      return (_columns$index = columns[index]) === null || _columns$index === void 0 ? void 0 : _columns$index.id;
    };
    return (0, _top_values.fromTermsLensApiToLensState)(options, findByIndex);
  }
  // @ts-expect-error This should never happen if the types are correct
  throw new Error(`Unsupported bucket operation: "${options.operation}"`);
}
function fromBucketLensStateToAPI(column, columns) {
  if ((0, _utils.isLensStateColumnOfType)('filters', column)) {
    return (0, _filters.fromFiltersLensStateToAPI)(column);
  }
  if ((0, _utils.isLensStateColumnOfType)('date_histogram', column)) {
    return (0, _date_histogram.fromDateHistogramLensStateToAPI)(column);
  }
  if ((0, _utils.isLensStateColumnOfType)('range', column)) {
    return (0, _range.fromRangeOrHistogramLensStateToAPI)(column);
  }
  if ((0, _utils.isLensStateColumnOfType)('terms', column)) {
    return (0, _top_values.fromTermsLensStateToAPI)(column, columns);
  }
  // @ts-expect-error This should never happen if the types are correct
  throw new Error(`Unsupported bucket operation: "${column.operationType}"`);
}