"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAPIAnnotationsLayer = buildAPIAnnotationsLayer;
exports.buildAPIDataLayer = buildAPIDataLayer;
exports.buildAPIReferenceLinesLayer = buildAPIReferenceLinesLayer;
var _lensCommon = require("@kbn/lens-common");
var _utils = require("../../../utils");
var _constants = require("../../../schema/constants");
var _utils2 = require("../../utils");
var _esql_column = require("../../columns/esql_column");
var _coloring = require("../../coloring");
var _utils3 = require("../../columns/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function convertDataLayerToAPI(visualization, layer) {
  var _visualization$yConfi, _visualization$access3;
  const yConfigMap = new Map((_visualization$yConfi = visualization.yConfig) === null || _visualization$yConfi === void 0 ? void 0 : _visualization$yConfi.map(y => [y.forAccessor, y]));
  if ((0, _utils2.isFormBasedLayer)(layer)) {
    var _visualization$access, _visualization$access2;
    const x = visualization.xAccessor ? (0, _utils2.operationFromColumn)(visualization.xAccessor, layer) : undefined;
    if (x && !(0, _utils3.isAPIColumnOfBucketType)(x)) {
      throw new Error('X axis must be a bucket operation');
    }

    // eslint-disable-next-line @typescript-eslint/naming-convention
    const breakdown_by = visualization.splitAccessor ? (0, _utils2.operationFromColumn)(visualization.splitAccessor, layer) : undefined;
    if (breakdown_by && !(0, _utils3.isAPIColumnOfBucketType)(breakdown_by)) {
      throw new Error('Breakdown by axis must be a bucket operation');
    }
    const y = (_visualization$access = (_visualization$access2 = visualization.accessors) === null || _visualization$access2 === void 0 ? void 0 : _visualization$access2.map(accessor => {
      const apiOperation = (0, _utils2.operationFromColumn)(accessor, layer);
      if (!apiOperation || (0, _utils3.isAPIColumnOfBucketType)(apiOperation) || (0, _utils3.isAPIColumnOfType)('static_value', apiOperation)) {
        return undefined;
      }
      const yConfig = yConfigMap.get(accessor);
      return {
        ...apiOperation,
        ...(visualization.colorMapping ? {} : yConfig !== null && yConfig !== void 0 && yConfig.color ? {
          color: (0, _coloring.fromStaticColorLensStateToAPI)(yConfig.color)
        } : {})
      };
    }).filter(_utils2.nonNullable)) !== null && _visualization$access !== void 0 ? _visualization$access : [];
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const aggregate_first = visualization.splitAccessor && visualization.xAccessor && layer.columnOrder[0] === visualization.splitAccessor;
    return {
      ...(0, _utils2.generateApiLayer)(layer),
      ...(x ? {
        x
      } : {}),
      y,
      ...(breakdown_by ? {
        breakdown_by: {
          ...breakdown_by,
          ...(visualization.collapseFn ? {
            collapse_by: visualization.collapseFn
          } : {}),
          ...(aggregate_first ? {
            aggregate_first: true
          } : {}),
          ...(visualization.colorMapping ? {
            color: (0, _coloring.fromColorMappingLensStateToAPI)(visualization.colorMapping)
          } : {})
        }
      } : {})
    };
  }
  const x = visualization.xAccessor ? (0, _esql_column.getValueApiColumn)(visualization.xAccessor, layer) : undefined;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const breakdown_by = visualization.splitAccessor ? (0, _esql_column.getValueApiColumn)(visualization.splitAccessor, layer) : undefined;
  const y = (_visualization$access3 = visualization.accessors) === null || _visualization$access3 === void 0 ? void 0 : _visualization$access3.map(accessor => {
    const {
      color
    } = yConfigMap.get(accessor) || {};
    return {
      ...(0, _esql_column.getValueApiColumn)(accessor, layer),
      ...(color ? {
        color: (0, _coloring.fromStaticColorLensStateToAPI)(color)
      } : {})
    };
  });
  return {
    ...(0, _utils2.generateApiLayer)(layer),
    ...(x ? {
      x
    } : {}),
    y: y || [],
    ...(breakdown_by ? {
      breakdown_by
    } : {})
  };
}
const seriesTypeFromStateToAPIMap = {
  bar: 'bar',
  bar_stacked: 'bar_stacked',
  bar_percentage_stacked: 'bar_percentage',
  bar_horizontal: 'bar_horizontal',
  bar_horizontal_stacked: 'bar_horizontal_stacked',
  bar_horizontal_percentage_stacked: 'bar_horizontal_percentage',
  line: 'line',
  area: 'area',
  area_stacked: 'area_stacked',
  area_percentage_stacked: 'area_percentage'
};
function convertSeriesTypeToAPIFormat(seriesType) {
  return seriesTypeFromStateToAPIMap[seriesType];
}
function buildAPIDataLayer(visualization, layer, adHocDataViews, references, adhocReferences) {
  const type = convertSeriesTypeToAPIFormat(visualization.seriesType);
  if ((0, _utils2.isTextBasedLayer)(layer)) {
    const dataset = (0, _utils2.buildDatasetState)(layer, visualization.layerId, adHocDataViews, references, adhocReferences);
    const baseLayer = convertDataLayerToAPI(visualization, layer);
    if ((0, _utils.isEsqlTableTypeDataset)(dataset)) {
      return {
        type,
        dataset,
        ...baseLayer
      };
    }
    // this should be a never as schema should ensure this scenario never happens
    throw new Error('Text based layers can only be used with ESQL or Table datasets');
  }
  const dataset = (0, _utils2.buildDatasetState)(layer, visualization.layerId, adHocDataViews, references, adhocReferences);
  if ((0, _utils.isEsqlTableTypeDataset)(dataset)) {
    // this should be a never as schema should ensure this scenario never happens
    throw new Error('Form based layers cannot be used with ESQL or Table datasets');
  }
  const baseLayer = convertDataLayerToAPI(visualization, layer);
  return {
    type,
    dataset,
    ...baseLayer
  };
}
const referenceLinesAvailableIconsSet = new Set(Object.values(_lensCommon.AvailableReferenceLineIcons));
function isReferenceLineValidIcon(icon) {
  return Boolean(icon && referenceLinesAvailableIconsSet.has(icon));
}
function convertReferenceLinesDecorationsToAPIFormat(yConfig) {
  return {
    ...(yConfig.color ? {
      color: (0, _coloring.fromStaticColorLensStateToAPI)(yConfig.color)
    } : {}),
    ...(yConfig.lineStyle ? {
      stroke_dash: yConfig.lineStyle
    } : {}),
    ...(yConfig.lineWidth ? {
      stroke_width: yConfig.lineWidth
    } : {}),
    ...(isReferenceLineValidIcon(yConfig.icon) ? {
      icon: yConfig.icon
    } : {}),
    ...(yConfig.fill && yConfig.fill !== 'none' ? {
      fill: yConfig.fill
    } : {}),
    ...(yConfig.axisMode && yConfig.axisMode !== 'auto' ? {
      axis: yConfig.axisMode
    } : {}),
    ...(yConfig.textVisibility != null ? {
      text: yConfig.textVisibility ? 'label' : 'none'
    } : {})
  };
}
function getLabelFromLayer(forAccessor, layer) {
  var _layer$columns$find;
  if ((0, _utils2.isFormBasedLayer)(layer)) {
    var _layer$columns$forAcc;
    return (_layer$columns$forAcc = layer.columns[forAccessor]) === null || _layer$columns$forAcc === void 0 ? void 0 : _layer$columns$forAcc.label;
  }
  return (_layer$columns$find = layer.columns.find(col => col.columnId === forAccessor)) === null || _layer$columns$find === void 0 ? void 0 : _layer$columns$find.label;
}
function convertReferenceLineLayerToAPI(visualization, layer) {
  var _visualization$yConfi2, _visualization$access4, _visualization$access5;
  const yConfigMap = new Map((_visualization$yConfi2 = visualization.yConfig) === null || _visualization$yConfi2 === void 0 ? void 0 : _visualization$yConfi2.map(y => [y.forAccessor, y]));
  const thresholds = (_visualization$access4 = (_visualization$access5 = visualization.accessors) === null || _visualization$access5 === void 0 ? void 0 : _visualization$access5.map(accessor => {
    const label = getLabelFromLayer(accessor, layer);
    const {
      forAccessor,
      ...yConfigRest
    } = yConfigMap.get(accessor) || {};
    const decorationConfig = convertReferenceLinesDecorationsToAPIFormat(yConfigRest);

    // this is very annoying as TS cannot seem to narrow the type correctly here
    // if we move this check outside the loop
    if ((0, _utils2.isFormBasedLayer)(layer)) {
      const op = (0, _utils2.operationFromColumn)(accessor, layer);
      if (op == null || (0, _utils3.isAPIColumnOfBucketType)(op) || (0, _utils3.isAPIColumnOfReferenceType)(op)) {
        return undefined;
      }
      return {
        ...op,
        ...(label != null ? {
          label
        } : {}),
        ...decorationConfig
      };
    }
    const op = (0, _esql_column.getValueApiColumn)(accessor, layer);
    if (!op) {
      return undefined;
    }
    return {
      ...op,
      ...(label != null ? {
        label
      } : {}),
      ...decorationConfig
    };
  }).filter(_utils2.nonNullable)) !== null && _visualization$access4 !== void 0 ? _visualization$access4 : [];
  return {
    ...(0, _utils2.generateApiLayer)(layer),
    // cannot really workout why satisfies works above and not here
    thresholds: thresholds
  };
}
function buildAPIReferenceLinesLayer(visualization, layer, adHocDataViews, references, adhocReferences) {
  const dataset = (0, _utils2.buildDatasetState)(layer, visualization.layerId, adHocDataViews, references, adhocReferences);
  if ((0, _utils2.isTextBasedLayer)(layer)) {
    if ((0, _utils.isEsqlTableTypeDataset)(dataset)) {
      return {
        type: 'referenceLines',
        dataset,
        ...convertReferenceLineLayerToAPI(visualization, layer)
      };
    }
    throw new Error('Text based layers can only be used with ESQL or Table datasets');
  }
  if ((0, _utils.isEsqlTableTypeDataset)(dataset)) {
    throw new Error('Form based layers cannot be used with ESQL or Table datasets');
  }
  return {
    type: 'referenceLines',
    dataset,
    ...convertReferenceLineLayerToAPI(visualization, layer)
  };
}
function findAnnotationDataView(layerId, references) {
  const ref = references.find(r => r.name === `xy-visualization-layer-${layerId}`);
  return ref === null || ref === void 0 ? void 0 : ref.id;
}
function getTextConfigurationForQueryAnnotation(annotation) {
  const textConfig = {
    ...('label' in annotation && annotation.label ? {
      label: annotation.label
    } : {})
  };
  if ('textVisibility' in annotation && annotation.textVisibility != null) {
    if ('textField' in annotation && annotation.textField) {
      return {
        ...textConfig,
        text: {
          type: 'field',
          field: annotation.textField
        }
      };
    }
    return {
      ...textConfig,
      text: annotation.textVisibility ? 'label' : 'none'
    };
  }
  return textConfig;
}
function buildAPIAnnotationsLayer(visualization, adHocDataViews, references, adhocReferences) {
  var _visualization$ignore;
  // eslint-disable-next-line @typescript-eslint/naming-convention
  const ignore_global_filters = (_visualization$ignore = visualization.ignoreGlobalFilters) !== null && _visualization$ignore !== void 0 ? _visualization$ignore : _constants.LENS_IGNORE_GLOBAL_FILTERS_DEFAULT_VALUE;
  const adHocDataView = adHocDataViews[visualization.layerId];
  const referencedDataView = findAnnotationDataView(visualization.layerId, references);
  const dataset = (0, _utils2.isDataViewSpec)(adHocDataView) && (adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.id) === visualization.indexPatternId ? {
    type: 'index',
    index: visualization.indexPatternId,
    time_field: adHocDataView.timeFieldName
  } : {
    type: 'dataView',
    id: referencedDataView !== null && referencedDataView !== void 0 ? referencedDataView : visualization.indexPatternId
  };
  return {
    type: 'annotations',
    dataset,
    ignore_global_filters,
    events: visualization.annotations.map(annotation => {
      if (annotation.type === 'query') {
        return {
          type: 'query',
          label: annotation.label,
          query: annotation.filter ? {
            language: annotation.filter.language,
            // it should never be a non-string here as schema ensures that
            query: typeof annotation.filter.query === 'string' ? annotation.filter.query : ''
          } : {
            language: 'kuery',
            query: ''
          },
          time_field: annotation.timeField,
          ...(annotation.extraFields ? {
            extra_fields: annotation.extraFields
          } : {}),
          color: annotation.color ? (0, _coloring.fromStaticColorLensStateToAPI)(annotation.color) : undefined,
          ...(annotation.isHidden != null ? {
            hidden: annotation.isHidden
          } : {}),
          ...getTextConfigurationForQueryAnnotation(annotation)
        };
      }
      if (annotation.key.type === 'range') {
        return {
          type: 'range',
          interval: {
            from: annotation.key.timestamp,
            to: annotation.key.endTimestamp
          },
          color: annotation.color ? (0, _coloring.fromStaticColorLensStateToAPI)(annotation.color) : undefined,
          fill: 'outside' in annotation && annotation.outside ? 'outside' : 'inside',
          ...(annotation.isHidden != null ? {
            hidden: annotation.isHidden
          } : {}),
          ...('label' in annotation && annotation.label ? {
            label: annotation.label
          } : {})
        };
      }
      return {
        type: 'point',
        timestamp: annotation.key.timestamp,
        color: annotation.color ? (0, _coloring.fromStaticColorLensStateToAPI)(annotation.color) : undefined,
        ...(annotation.isHidden != null ? {
          hidden: annotation.isHidden
        } : {}),
        ...('textVisibility' in annotation && annotation.textVisibility != null ? {
          text: annotation.textVisibility ? 'label' : 'none'
        } : {}),
        ...('label' in annotation && annotation.label ? {
          label: annotation.label
        } : {})
      };
    })
  };
}