"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _utils = require("./utils");
var _utils2 = require("../utils");
var _chart = require("./xy/chart");
var _state_layers = require("./xy/state_layers");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromAPItoLensState(config) {
  // convert layers and produce references from them
  const {
    layers,
    usedDataviews
  } = (0, _utils2.buildDatasourceStates)(config, _state_layers.buildFormBasedXYLayer, _state_layers.getValueColumns);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils2.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.entries(usedDataviews).filter(v => v[1].type === 'dataView');
  const regularDataViewsMap = Object.fromEntries(regularDataViews.map(([key, {
    id
  }]) => [key, id]));
  // merge both internal references and regularDataViews into a single map { layerId => dataViewId }
  const dataViewLayerToIdMap = Object.fromEntries([...Object.entries(regularDataViewsMap).map(([layerId, dataViewId]) => [layerId, dataViewId]), ...internalReferences.map(ref => [ref.name.replace(_constants.LENS_LAYER_SUFFIX, ''), ref.id])]);
  const visualizationState = (0, _chart.buildVisualizationState)(config, dataViewLayerToIdMap);
  // @TODO: support annotation references
  const references = regularDataViews.length ? (0, _utils2.buildReferences)(regularDataViewsMap) : [];
  return {
    visualizationType: 'lnsXY',
    ...(0, _utils.getSharedChartAPIToLensState)(config),
    state: {
      datasourceStates: layers,
      ...(internalReferences.length ? {
        internalReferences
      } : {}),
      visualization: visualizationState,
      ...(Object.keys(adHocDataViews).length ? {
        adHocDataViews
      } : {})
    },
    references
  };
}
function fromLensStateToAPI(config) {
  var _config$state$adHocDa, _config$state$interna;
  const {
    state
  } = config;
  const visualizationState = state.visualization;
  const layers = (0, _utils.getDatasourceLayers)(state);
  return {
    ...(0, _utils.getSharedChartLensStateToAPI)(config),
    ...(0, _chart.buildVisualizationAPI)(visualizationState, layers, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, (_config$state$interna = config.state.internalReferences) !== null && _config$state$interna !== void 0 ? _config$state$interna : [])
  };
}