"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedPanelInfoSchema = exports.layerSettingsSchema = exports.ignoringGlobalFiltersSchemaRaw = exports.dslOnlyPanelInfoSchema = exports.collapseBySchema = exports.axisTitleSchemaProps = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
var _filter = require("./filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sharedPanelInfoSchema = exports.sharedPanelInfoSchema = {
  /**
   * The title of the chart displayed in the panel.
   *
   * Optional. If not provided, the chart will not have a title.
   *
   * Possible values: Any string value, or undefined if omitted.
   */
  title: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The title of the chart displayed in the panel. Optional. Any string value or undefined.'
    }
  })),
  /**
   * The description of the chart, providing additional context or information.
   *
   * Optional. If not provided, the chart will not have a description.
   *
   * Possible values: Any string value, or undefined if omitted.
   */
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The description of the chart. Optional. Any string value or undefined.'
    }
  })),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_filter.unifiedSearchFilterSchema))
};
const dslOnlyPanelInfoSchema = exports.dslOnlyPanelInfoSchema = {
  // ES|QL chart should not have the ability to define a KQL/Lucene query
  query: _configSchema.schema.maybe(_filter.filterSchema)
};
const ignoringGlobalFiltersSchemaRaw = exports.ignoringGlobalFiltersSchemaRaw = {
  /**
   * Whether to ignore global filters when fetching data for this layer.
   *
   * If true, global filters (such as those set in the dashboard or application context) will be ignored for this layer.
   * If false, global filters will be applied.
   *
   * Default: false
   * Possible values: boolean (true or false)
   */
  ignore_global_filters: _configSchema.schema.boolean({
    defaultValue: _constants.LENS_IGNORE_GLOBAL_FILTERS_DEFAULT_VALUE,
    meta: {
      description: 'If true, ignore global filters when fetching data for this layer. Default is false.'
    }
  })
};
const layerSettingsSchema = exports.layerSettingsSchema = {
  /**
   * The sampling factor for the dataset.
   *
   * Determines the proportion of the dataset to be used. Must be a number between 0 and 1 (inclusive).
   * - 0: No sampling (use none of the data)
   * - 1: Full sampling (use all data)
   * - Any value between 0 and 1: Use that proportion of the data
   *
   * Default: 1
   * Possible values: number (0 <= value <= 1)
   */
  sampling: _configSchema.schema.number({
    min: _constants.LENS_SAMPLING_MIN_VALUE,
    max: _constants.LENS_SAMPLING_MAX_VALUE,
    defaultValue: _constants.LENS_SAMPLING_DEFAULT_VALUE,
    meta: {
      description: 'Sampling factor between 0 (no sampling) and 1 (full sampling). Default is 1.'
    }
  }),
  ...ignoringGlobalFiltersSchemaRaw
};
const collapseBySchema = exports.collapseBySchema = _configSchema.schema.oneOf([
/**
 * Average collapsed by average function
 */
_configSchema.schema.literal('avg'),
/**
 * Sum collapsed by sum function
 */
_configSchema.schema.literal('sum'),
/**
 * Max collapsed by max function
 */
_configSchema.schema.literal('max'),
/**
 * Min collapsed by min function
 */
_configSchema.schema.literal('min')], {
  meta: {
    description: 'Collapse by function description'
  }
});
const layerSettingsSchemaWrapped = _configSchema.schema.object(layerSettingsSchema);
const axisTitleSchemaProps = exports.axisTitleSchemaProps = {
  value: _configSchema.schema.maybe(_configSchema.schema.string({
    defaultValue: '',
    meta: {
      description: 'Axis title text'
    }
  })),
  visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Whether to show the title'
    }
  }))
};