"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datatableStateSchemaNoESQL = exports.datatableStateSchemaESQL = exports.datatableStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _lensCommon = require("@kbn/lens-common");
var _lodash = require("lodash");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
var _alignments = require("../alignments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const datatableStateSharedOptionsSchema = {
  /**
   * Density  configuration
   */
  density: _configSchema.schema.maybe(_configSchema.schema.object({
    /**
     * Density mode
     */
    mode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('compact'), _configSchema.schema.literal('default'), _configSchema.schema.literal('expanded')], {
      defaultValue: 'default',
      meta: {
        description: 'Density mode'
      }
    })),
    /**
     * Height configuration
     */
    height: _configSchema.schema.maybe(_configSchema.schema.object({
      header: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.object({
        type: _configSchema.schema.literal('auto')
      }), _configSchema.schema.object({
        type: _configSchema.schema.literal('custom'),
        max_lines: _configSchema.schema.number({
          defaultValue: _lensCommon.DEFAULT_HEADER_ROW_HEIGHT_LINES,
          min: 1,
          max: 5
        })
      })], {
        meta: {
          description: 'Maximum number of lines to use before header is truncated'
        }
      })),
      value: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.object({
        type: _configSchema.schema.literal('auto')
      }), _configSchema.schema.object({
        type: _configSchema.schema.literal('custom'),
        lines: _configSchema.schema.number({
          defaultValue: _lensCommon.DEFAULT_ROW_HEIGHT_LINES,
          min: 1,
          max: 20
        })
      })], {
        meta: {
          description: 'Number of lines to display per table body cell'
        }
      }))
    }))
  }, {
    meta: {
      description: 'Density configuration for the datatable'
    }
  })),
  /**
   * Paging configuration
   */
  paging: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(10), _configSchema.schema.literal(20), _configSchema.schema.literal(50), _configSchema.schema.literal(100)], {
    meta: {
      description: 'Enables pagination and sets the number of rows to display per page'
    }
  }))
};

/**
 * Sorting configuration split_metrics_by
 */
const splitMetricsBySortingSchema = {
  direction: _configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
    defaultValue: 'asc',
    meta: {
      description: 'Direction to sort by'
    }
  }),
  value: _configSchema.schema.string({
    meta: {
      description: 'The transposed column value to sort by (e.g., if split_metrics_by uses "status" field, this could be "success" or "error")'
    }
  })
};

/**
 * Sorting configuration for rows and metrics
 */
const rowsMetricsSortingSchema = (0, _lodash.omit)(splitMetricsBySortingSchema, ['value']);
const datatableStateCommonOptionsSchema = {
  /**
   * Where to apply the color (background or value)
   */
  apply_color_to: _configSchema.schema.maybe(_color.applyColorToSchema),
  /**
   * Whether to show the row
   */
  visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true
  })),
  /**
   * Whether to sort by this column
   */
  sorted: _configSchema.schema.maybe(_configSchema.schema.object(rowsMetricsSortingSchema, {
    meta: {
      description: 'Sorting configuration. Only one column across metrics, rows, and split_metrics_by can be sorted at a time.'
    }
  }))
};
const datatableStateRowsOptionsSchema = _configSchema.schema.object({
  ...datatableStateCommonOptionsSchema,
  /**
   * Alignment of the rows
   */
  alignment: _configSchema.schema.maybe((0, _alignments.horizontalAlignmentSchema)({
    defaultValue: 'left',
    meta: {
      description: 'Alignment of the rows'
    }
  })),
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.colorMappingSchema),
  /**
   * Whether to enable the one click filter
   */
  click_filter: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Whether to enable the one click filter'
    }
  })),
  /**
   * Collapse by function. This parameter is used to collapse the
   * metric chart when the number of columns is bigger than the
   * number of columns specified in the columns parameter.
   */
  collapse_by: _configSchema.schema.maybe(_shared.collapseBySchema)
});
const datatableStateMetricsOptionsSchema = _configSchema.schema.object({
  ...datatableStateCommonOptionsSchema,
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.colorByValueSchema),
  /**
   * Alignment of the columns
   */
  alignment: _configSchema.schema.maybe((0, _alignments.horizontalAlignmentSchema)({
    defaultValue: 'right',
    meta: {
      description: 'Alignment of the columns'
    }
  })),
  /**
   * Summary configuration
   */
  summary: _configSchema.schema.maybe(_configSchema.schema.object({
    type: _configSchema.schema.oneOf([_configSchema.schema.literal('sum'), _configSchema.schema.literal('avg'), _configSchema.schema.literal('count'), _configSchema.schema.literal('min'), _configSchema.schema.literal('max')], {
      meta: {
        description: 'Type of summary function to apply to the column'
      }
    }),
    label: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'Summary row label'
      }
    }))
  }, {
    meta: {
      description: 'Summary row configuration'
    }
  }))
});
const datatableStateSplitMetricsByOptionsSchema = _configSchema.schema.object({
  /**
   * Sorting configuration for the split metrics by
   */
  sorted: _configSchema.schema.maybe(_configSchema.schema.object(splitMetricsBySortingSchema, {
    meta: {
      description: 'Sorting configuration for the split metrics by. Only one column across metrics, rows, and split_metrics_by can be sorted at a time.'
    }
  }))
});
function validateSorting({
  metrics,
  rows,
  split_metrics_by
}) {
  const allColumns = metrics.concat(rows !== null && rows !== void 0 ? rows : [], split_metrics_by !== null && split_metrics_by !== void 0 ? split_metrics_by : []);
  if (allColumns.filter(column => 'sorted' in column && column.sorted).length > 1) {
    return 'Only one column across metrics, rows, and split_metrics_by can be sorted at a time.';
  }
}
const datatableStateSchemaNoESQL = exports.datatableStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('datatable'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...datatableStateSharedOptionsSchema,
  /**
   * Metric columns configuration, must define operation.
   */
  metrics: _configSchema.schema.arrayOf((0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(datatableStateMetricsOptionsSchema), {
    minSize: 1,
    maxSize: 1000,
    meta: {
      description: 'Array of metrics to display as columns in the datatable'
    }
  }),
  /**
   * Row configuration, optional bucket operations.
   */
  rows: _configSchema.schema.maybe(_configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(datatableStateRowsOptionsSchema), {
    minSize: 1,
    maxSize: 50,
    meta: {
      description: 'Array of operations to split the datatable rows by'
    }
  })),
  /**
   * Split metrics by configuration, optional bucket operations.
   */
  split_metrics_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(datatableStateSplitMetricsByOptionsSchema), {
    minSize: 1,
    maxSize: 20,
    meta: {
      description: 'Array of operations to split the metric columns by'
    }
  }))
}, {
  validate: validateSorting,
  meta: {
    description: 'Datatable state configuration for standard queries'
  }
});
const datatableStateSchemaESQL = exports.datatableStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('datatable'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...datatableStateSharedOptionsSchema,
  /**
   * Metric columns configuration, must define operation.
   */
  metrics: _configSchema.schema.arrayOf(_configSchema.schema.allOf([_configSchema.schema.object({
    ..._metric_ops.genericOperationOptionsSchema
  }), datatableStateMetricsOptionsSchema, _metric_ops.esqlColumnSchema]), {
    minSize: 1,
    maxSize: 1000,
    meta: {
      description: 'Array of metrics to display as columns in the datatable'
    }
  }),
  /**
   * Row configuration, optional operations.
   */
  rows: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.allOf([datatableStateRowsOptionsSchema, _metric_ops.esqlColumnSchema]), {
    minSize: 1,
    maxSize: 50,
    meta: {
      description: 'Array of operations to split the datatable rows by'
    }
  })),
  /**
   * Split metrics by configuration, optional operations.
   */
  split_metrics_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_metric_ops.esqlColumnSchema, {
    minSize: 1,
    maxSize: 20,
    meta: {
      description: 'Array of operations to split the metric columns by'
    }
  }))
}, {
  validate: validateSorting,
  meta: {
    description: 'Datatable state configuration for ES|QL queries'
  }
});
const datatableStateSchema = exports.datatableStateSchema = _configSchema.schema.oneOf([datatableStateSchemaNoESQL, datatableStateSchemaESQL], {
  meta: {
    description: 'Datatable chart configuration: DSL or ES|QL query based'
  }
});