"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.verticalAlignmentSchema = exports.positionSchema = exports.leftRightAlignmentSchema = exports.horizontalAlignmentSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HORIZONTAL_ALIGN = ['left', 'center', 'right'];
const VERTICAL_ALIGN = ['top', 'bottom'];
const LR_ALIGN = ['left', 'right'];
const horizontalAlignmentSchema = opts => _configSchema.schema.oneOf([_configSchema.schema.literal('left'), _configSchema.schema.literal('center'), _configSchema.schema.literal('right')], opts);
exports.horizontalAlignmentSchema = horizontalAlignmentSchema;
const verticalAlignmentSchema = opts => _configSchema.schema.oneOf([_configSchema.schema.literal('top'), _configSchema.schema.literal('bottom')], opts);
exports.verticalAlignmentSchema = verticalAlignmentSchema;
const leftRightAlignmentSchema = opts => _configSchema.schema.oneOf([_configSchema.schema.literal('left'), _configSchema.schema.literal('right')], opts);
exports.leftRightAlignmentSchema = leftRightAlignmentSchema;
const positionSchema = opts => _configSchema.schema.oneOf([_configSchema.schema.literal('top'), _configSchema.schema.literal('bottom'), _configSchema.schema.literal('left'), _configSchema.schema.literal('right')], opts);
exports.positionSchema = positionSchema;