"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockDataViewsService = mockDataViewsService;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dataViews = {
  test: {
    id: 'test',
    fields: {
      getByName: name => {
        switch (name) {
          case '@timestamp':
            return {
              type: 'datetime'
            };
          case 'category':
            return {
              type: 'string'
            };
          case 'price':
            return {
              type: 'number'
            };
          default:
            return undefined;
        }
      }
    }
  }
};
function mockDataViewsService() {
  return {
    get: jest.fn(async id => {
      const result = {
        ...dataViews[id],
        metaFields: [],
        isPersisted: () => true,
        toSpec: () => ({})
      };
      return result;
    }),
    create: jest.fn(async ({
      id
    }) => {
      const {
        index
      } = JSON.parse(id);
      const result = {
        ...dataViews[index],
        metaFields: [],
        isPersisted: () => true,
        toSpec: () => ({})
      };
      return result;
    })
  };
}