"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_HEATMAP_ID = exports.LENS_HEATMAP_GROUP_ID = exports.LENS_HEATMAP_DEFAULT_PALETTE_PARAMS = exports.LENS_HEATMAP_DEFAULT_PALETTE_NAME = exports.LENS_HEATMAP_CHART_SHAPES = exports.LENS_HEATMAP_CHART_NAMES = exports.HEATMAP_NAME = exports.HEATMAP_LEGEND_NAME = exports.HEATMAP_GRID_NAME = void 0;
var _chartIcons = require("@kbn/chart-icons");
var _i18n = require("@kbn/i18n");
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LENS_HEATMAP_ID = exports.LENS_HEATMAP_ID = 'lnsHeatmap';
const LENS_HEATMAP_CHART_SHAPES = exports.LENS_HEATMAP_CHART_SHAPES = {
  HEATMAP: 'heatmap'
};
const LENS_HEATMAP_CHART_NAMES = exports.LENS_HEATMAP_CHART_NAMES = {
  heatmap: {
    shapeType: LENS_HEATMAP_CHART_SHAPES.HEATMAP,
    icon: _chartIcons.IconChartHeatmap,
    label: _i18n.i18n.translate('xpack.lens.heatmap.heatmapLabel', {
      defaultMessage: 'Heat map'
    })
  }
};
const LENS_HEATMAP_GROUP_ID = exports.LENS_HEATMAP_GROUP_ID = {
  X: 'x',
  Y: 'y',
  CELL: 'cell'
};
const HEATMAP_NAME = exports.HEATMAP_NAME = 'heatmap';
const HEATMAP_LEGEND_NAME = exports.HEATMAP_LEGEND_NAME = 'heatmap_legend';
const HEATMAP_GRID_NAME = exports.HEATMAP_GRID_NAME = 'heatmap_grid';
const LENS_HEATMAP_DEFAULT_PALETTE_NAME = exports.LENS_HEATMAP_DEFAULT_PALETTE_NAME = 'temperature';
const LENS_HEATMAP_DEFAULT_PALETTE_PARAMS = exports.LENS_HEATMAP_DEFAULT_PALETTE_PARAMS = {
  name: 'temperature',
  reverse: false,
  rangeType: 'percent',
  rangeMin: _coloring.DEFAULT_MIN_STOP,
  rangeMax: _coloring.DEFAULT_MAX_STOP,
  progression: _coloring.FIXED_PROGRESSION,
  stops: [],
  steps: _coloring.DEFAULT_COLOR_STEPS,
  colorStops: [],
  continuity: _coloring.DEFAULT_CONTINUITY
};