"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size
    } = euiTheme;
    const treeViewSwitcher = {
      '.euiButton__text': {
        fontSize: size.m
      }
    };
    const treeViewContainer = {
      height: '600px',
      width: '288px',
      overflowY: 'auto'
    };
    const treeViewLegend = {
      textTransform: 'capitalize'
    };
    return {
      treeViewSwitcher,
      treeViewContainer,
      treeViewLegend
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;