"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerificationCodeForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _get_command_line_snippet = require("./get_command_line_snippet");
var _single_chars_field = require("./single_chars_field");
var _submit_error_callout = require("./submit_error_callout");
var _use_form = require("./use_form");
var _use_kibana = require("./use_kibana");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/interactive_setup/public/verification_code_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const VerificationCodeForm = ({
  defaultValues = {
    code: ''
  },
  onSuccess
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const [form, eventHandlers] = (0, _use_form.useForm)({
    defaultValues,
    validate: async values => {
      const errors = {};
      if (!values.code) {
        errors.code = _i18n.i18n.translate('interactiveSetup.verificationCodeForm.codeRequiredError', {
          defaultMessage: 'Enter the verification code from the Kibana server.'
        });
      } else if (values.code.length !== _common.VERIFICATION_CODE_LENGTH) {
        errors.code = _i18n.i18n.translate('interactiveSetup.verificationCodeForm.codeMinLengthError', {
          defaultMessage: 'Enter all six digits.'
        });
      }
      return errors;
    },
    onSubmit: async values => {
      try {
        await http.post('/internal/interactive_setup/verify', {
          body: JSON.stringify({
            code: values.code
          })
        });
      } catch (error) {
        var _response;
        if (((_response = error.response) === null || _response === void 0 ? void 0 : _response.status) === 403) {
          var _body;
          form.setError('code', ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || '');
          return;
        } else {
          throw error;
        }
      }
      onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(values);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    noValidate: true,
    onSubmit: eventHandlers.onSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.verificationCodeForm.title",
      defaultMessage: "Verification required",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, form.submitError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_submit_error_callout.SubmitErrorCallout, {
      error: form.submitError,
      defaultTitle: _i18n.i18n.translate('interactiveSetup.verificationCodeForm.submitErrorTitle', {
        defaultMessage: "Couldn't verify code"
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.verificationCodeForm.codeDescription",
      defaultMessage: "Copy the code from the Kibana server or run {command} to retrieve it.",
      values: {
        command: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          language: "bash",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 23
          }
        }, (0, _get_command_line_snippet.getCommandLineSnippet)('kibana-verification-code'))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      error: form.errors.code,
      isInvalid: form.touched.code && !!form.errors.code,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_single_chars_field.SingleCharsField, {
      defaultValue: form.values.code,
      length: _common.VERIFICATION_CODE_LENGTH,
      separator: _common.VERIFICATION_CODE_LENGTH / 2,
      onChange: value => form.setValue('code', value),
      isInvalid: form.touched.code && !!form.errors.code,
      autoFocus: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 15
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      type: "submit",
      isLoading: form.isSubmitting,
      isDisabled: form.isSubmitted && form.isInvalid,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.verificationCodeForm.submitButton",
      defaultMessage: "{isSubmitting, select, true{Verifying\u2026} other{Verify}}",
      values: {
        isSubmitting: form.isSubmitting
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
};
exports.VerificationCodeForm = VerificationCodeForm;