"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersHealth = ClustersHealth;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cluster_health = require("./cluster_health");
var _gradient = require("./gradient");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/inspector/public/views/requests/components/details/clusters_view/clusters_health/clusters_health.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function ClustersHealth({
  clusters
}) {
  let successful = 0;
  let partial = 0;
  let skipped = 0;
  let failed = 0;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  Object.values(clusters).forEach(clusterDetails => {
    if (clusterDetails.status === 'successful') {
      successful++;
    } else if (clusterDetails.status === 'partial') {
      partial++;
    } else if (clusterDetails.status === 'skipped') {
      skipped++;
    } else if (clusterDetails.status === 'failed') {
      failed++;
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('inspector.requests.clusters.totalClustersLabel', {
    defaultMessage: '{total} {total, plural, one {cluster} other {clusters}}',
    values: {
      total: Object.keys(clusters).length
    }
  }))), successful > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: successful,
    status: "successful",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  })) : null, partial > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: partial,
    status: "partial",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  })) : null, skipped > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: skipped,
    status: "skipped",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })) : null, failed > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: failed,
    status: "failed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          background: ${(0, _gradient.useHeathBarLinearGradient)(successful, partial, skipped, failed)};
          border-radius: ${euiTheme.border.radius.small};
          height: ${euiTheme.size.s};
          margin-top: ${euiTheme.size.xs};
          margin-bottom: ${euiTheme.size.s};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
}