"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFiberFromHtmlElement = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Get the {@link ReactFiberNode React Fiber node} associated with a HTML element.
 * @param {HTMLElement | null} element The HTML element to get the {@link ReactFiberNode React Fiber node} from.
 * @returns {ReactFiberNode | null} The corresponding {@link ReactFiberNode React Fiber node}, or null if not found.
 */
const getFiberFromHtmlElement = element => {
  if (!element) return null;
  const fiberKey = Object.keys(element).find(key => key.startsWith('__reactFiber$'));
  return fiberKey ? element[fiberKey] : null;
};
exports.getFiberFromHtmlElement = getFiberFromHtmlElement;