"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Enrich = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _target_field = require("./common_fields/target_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/enrich.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField,
  numberSmallerThanField,
  numberGreaterThanField
} = _shared_imports.fieldValidators;
const maxMatchesValidators = {
  max: numberSmallerThanField({
    than: 128,
    allowEquality: true,
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.maxMatchesMaxNumberError', {
      defaultMessage: 'This number must be less than 128.'
    })
  }),
  min: numberGreaterThanField({
    than: 0,
    allowEquality: false,
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.maxMatchesMinNumberError', {
      defaultMessage: 'This number must be greater than 0.'
    })
  })
};
const targetFieldValidator = {
  validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.targetFieldRequiredError', {
    defaultMessage: 'A target field value is required.'
  }))
};
const fieldsConfig = {
  /* Required fields config */
  policy_name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.policyNameFieldLabel', {
      defaultMessage: 'Policy name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.policyNameRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }]
  },
  /* Optional fields config */
  override: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.overrideFieldLabel', {
      defaultMessage: 'Override'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.overrideFieldHelpText', {
      defaultMessage: 'If enabled, the processor can overwrite pre-existing field values.'
    })
  },
  max_matches: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    defaultValue: 1,
    deserializer: v => typeof v === 'number' && !isNaN(v) ? v : 1,
    serializer: v => {
      const n = parseInt(v, 10);
      return n === 1 ? undefined : n;
    },
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.maxMatchesFieldLabel', {
      defaultMessage: 'Maximum matches (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.maxMatchesFieldHelpText', {
      defaultMessage: 'Number of matching enrich documents to include in the target field. Accepts 1–128.'
    }),
    validations: [{
      validator: v => {
        if (v.value /* value is a string here */) {
          var _maxMatchesValidators;
          return (_maxMatchesValidators = maxMatchesValidators.max(v)) !== null && _maxMatchesValidators !== void 0 ? _maxMatchesValidators : maxMatchesValidators.min(v);
        }
      }
    }]
  },
  shape_relation: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'INTERSECTS',
    deserializer: String,
    serializer: v => v === 'INTERSECTS' ? undefined : v,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.shapeRelationFieldLabel', {
      defaultMessage: 'Shape relation (optional)'
    })
  }
};
const Enrich = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.fieldNameHelpText', {
      defaultMessage: 'Field used to match incoming documents to enrich documents. Field values are compared to the match field set in the enrich policy.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: {
      ...fieldsConfig.policy_name,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.enrichForm.policyNameHelpText",
        defaultMessage: "Name of the {enrichPolicyLink}.",
        values: {
          enrichPolicyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            external: true,
            target: "_blank",
            href: services.documentation.getEnrichDataUrl(),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 165,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.policyNameHelpText.enrichPolicyLink', {
            defaultMessage: 'enrich policy'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 13
        }
      })
    },
    component: _shared_imports.Field,
    path: "fields.policy_name",
    "data-test-subj": "policyNameField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.targetFieldLabel', {
      defaultMessage: 'Target field'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.targetFieldHelpText', {
      defaultMessage: 'Field used to contain enrich data.'
    }),
    validations: [targetFieldValidator],
    "data-test-subj": "targetField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.override,
    component: _shared_imports.ToggleField,
    path: "fields.override",
    "data-test-subj": "overrideField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.max_matches,
    component: _shared_imports.NumericField,
    path: "fields.max_matches",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: {
      ...fieldsConfig.shape_relation,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.enrichForm.shapeRelationFieldHelpText",
        defaultMessage: "Operator used to match the geo-shape of incoming documents to enrich documents. Only used for {geoMatchPolicyLink}.",
        values: {
          geoMatchPolicyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            external: true,
            target: "_blank",
            href: services.documentation.getGeoMatchUrl(),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 221,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.shapeRelationFieldHelpText.geoMatchPoliciesLink', {
            defaultMessage: 'geo-match enrich policies'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 13
        }
      })
    },
    component: _shared_imports.SelectField,
    componentProps: {
      euiFieldProps: {
        options: [{
          value: 'INTERSECTS',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.intersectsOption', {
            defaultMessage: 'Intersects'
          })
        }, {
          value: 'DISJOINT',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichFrom.disjointOption', {
            defaultMessage: 'Disjoint'
          })
        }, {
          value: 'WITHIN',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.withinOption', {
            defaultMessage: 'Within'
          })
        }, {
          value: 'CONTAINS',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.enrichForm.containsOption', {
            defaultMessage: 'Contains'
          })
        }]
      }
    },
    path: "fields.shape_relation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 7
    }
  }));
};
exports.Enrich = Enrich;