"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initServicesRoute = void 0;
var _host_details = require("../../../common/http_api/host_details");
var _utils = require("./lib/utils");
var _route_validation = require("../../utils/route_validation");
var _get_apm_data_access_client = require("../../lib/helpers/get_apm_data_access_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initServicesRoute = libs => {
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/services',
    validate: {
      query: (q, res) => {
        const [invalidResponse, parsedFilters] = (0, _utils.validateStringAssetFilters)(q, res);
        if (invalidResponse) {
          return invalidResponse;
        }
        q.validatedFilters = parsedFilters;
        return (0, _route_validation.buildRouteValidationWithExcess)(_host_details.GetServicesRequestQueryRT)(q, res);
      }
    }
  }, async (context, request, response) => {
    const {
      from,
      to,
      size = 10,
      validatedFilters
    } = request.query;
    const apmDataAccessClient = (0, _get_apm_data_access_client.getApmDataAccessClient)({
      request,
      libs,
      context
    });
    const apmDataAccessServices = await apmDataAccessClient.getServices();
    if (!apmDataAccessServices) {
      return response.ok({
        body: _host_details.ServicesAPIResponseRT.encode({
          services: []
        })
      });
    }
    const apmDocumentSources = await apmDataAccessServices.getDocumentSources({
      start: from,
      end: to
    });
    const services = await (apmDataAccessServices === null || apmDataAccessServices === void 0 ? void 0 : apmDataAccessServices.getHostServices({
      documentSources: apmDocumentSources,
      start: from,
      end: to,
      filters: validatedFilters,
      size
    }));
    return response.ok({
      body: _host_details.ServicesAPIResponseRT.encode(services)
    });
  });
};
exports.initServicesRoute = initServicesRoute;