"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initProcessListRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _configSchema = require("@kbn/config-schema");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _get_infra_metrics_client = require("../../lib/helpers/get_infra_metrics_client");
var _process_list = require("../../lib/host_details/process_list");
var _process_list_chart = require("../../lib/host_details/process_list_chart");
var _http_api = require("../../../common/http_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const escapeHatch = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const initProcessListRoute = libs => {
  const {
    framework
  } = libs;
  framework.registerRoute({
    method: 'post',
    path: '/api/metrics/process_list',
    validate: {
      body: (0, _ioTsUtils.createRouteValidationFunction)(_http_api.ProcessListAPIRequestRT)
    }
  }, async (context, request, response) => {
    try {
      const options = (0, _pipeable.pipe)(_http_api.ProcessListAPIRequestRT.decode(request.body), (0, _Either.fold)((0, _ioTsUtils.throwErrors)(_boom.default.badRequest), _function.identity));
      const infraMetricsClient = await (0, _get_infra_metrics_client.getInfraMetricsClient)({
        request,
        libs,
        context
      });
      const processListResponse = await (0, _process_list.getProcessList)(infraMetricsClient, options);
      return response.ok({
        body: _http_api.ProcessListAPIResponseRT.encode(processListResponse)
      });
    } catch (err) {
      var _err$statusCode, _err$message;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500,
        body: {
          message: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : 'An unexpected error occurred'
        }
      });
    }
  });
  framework.registerRoute({
    method: 'post',
    path: '/api/metrics/process_list/chart',
    validate: {
      body: escapeHatch
    }
  }, async (context, request, response) => {
    try {
      const options = (0, _pipeable.pipe)(_http_api.ProcessListAPIChartRequestRT.decode(request.body), (0, _Either.fold)((0, _ioTsUtils.throwErrors)(_boom.default.badRequest), _function.identity));
      const infraMetricsClient = await (0, _get_infra_metrics_client.getInfraMetricsClient)({
        request,
        libs,
        context
      });
      const processListResponse = await (0, _process_list_chart.getProcessListChart)(infraMetricsClient, options);
      return response.ok({
        body: _http_api.ProcessListAPIChartResponseRT.encode(processListResponse)
      });
    } catch (err) {
      var _err$statusCode2, _err$message2;
      if (_boom.default.isBoom(err)) {
        return response.customError({
          statusCode: err.output.statusCode,
          body: {
            message: err.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_err$statusCode2 = err.statusCode) !== null && _err$statusCode2 !== void 0 ? _err$statusCode2 : 500,
        body: {
          message: (_err$message2 = err.message) !== null && _err$message2 !== void 0 ? _err$message2 : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initProcessListRoute = initProcessListRoute;