"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initGetLogAnalysisIdFormatsRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _runtime_types = require("@kbn/logs-shared-plugin/common/runtime_types");
var _latest = require("../../../common/http_api/latest");
var _log_analysis = require("../../lib/log_analysis");
var _resolve_id_formats = require("../../lib/log_analysis/resolve_id_formats");
var _request_context = require("../../utils/request_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initGetLogAnalysisIdFormatsRoute = ({
  framework
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'post',
    path: _latest.LOG_ANALYSIS_GET_ID_FORMATS
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _runtime_types.createValidationFunction)(_latest.getLogAnalysisIdFormatsRequestPayloadRT)
      }
    }
  }, framework.router.handleLegacyErrors(async (requestContext, request, response) => {
    const {
      data: {
        logViewId,
        spaceId
      }
    } = request.body;
    try {
      const infraMlContext = await (0, _request_context.assertHasInfraMlPlugins)(requestContext);
      const mlAnomalyDetectors = (await infraMlContext.infra).mlAnomalyDetectors;
      const idFormatByJobType = await (0, _resolve_id_formats.resolveIdFormats)(logViewId, spaceId, mlAnomalyDetectors);
      return response.ok({
        body: _latest.getLogAnalysisIdFormatsSuccessResponsePayloadRT.encode({
          data: idFormatByJobType
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      if (_boom.default.isBoom(error)) {
        throw error;
      }
      if ((0, _log_analysis.isMlPrivilegesError)(error)) {
        return response.customError({
          statusCode: 403,
          body: {
            message: error.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  }));
};
exports.initGetLogAnalysisIdFormatsRoute = initGetLogAnalysisIdFormatsRoute;