"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntryCategoryHistogramsResponseRT = exports.logEntryCategoryFilterBucketRT = exports.createLogEntryCategoryHistogramsQuery = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _elasticsearch_runtime_types = require("../../../utils/elasticsearch_runtime_types");
var _common = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogEntryCategoryHistogramsQuery = (logEntryCategoriesJobId, categoryIds, startTime, endTime, bucketCount) => ({
  ..._common.defaultRequestParameters,
  body: {
    query: {
      bool: {
        filter: [...(0, _common.createJobIdFilters)(logEntryCategoriesJobId), ...(0, _common.createTimeRangeFilters)(startTime, endTime), ...(0, _common.createResultTypeFilters)(['model_plot']), ...createCategoryFilters(categoryIds)]
      }
    },
    aggs: {
      filters_categories: {
        filters: createCategoryFiltersAggregation(categoryIds),
        aggs: {
          histogram_timestamp: createHistogramAggregation(startTime, endTime, bucketCount)
        }
      }
    }
  },
  size: 0
});
exports.createLogEntryCategoryHistogramsQuery = createLogEntryCategoryHistogramsQuery;
const createCategoryFilters = categoryIds => [{
  terms: {
    by_field_value: categoryIds
  }
}];
const createCategoryFiltersAggregation = categoryIds => ({
  filters: categoryIds.reduce((categoryFilters, categoryId) => ({
    ...categoryFilters,
    [`${categoryId}`]: {
      term: {
        by_field_value: categoryId
      }
    }
  }), {})
});
const createHistogramAggregation = (startTime, endTime, bucketCount) => {
  const bucketDuration = Math.round((endTime - startTime) / bucketCount);
  return {
    histogram: {
      field: 'timestamp',
      interval: bucketDuration,
      offset: startTime
    },
    meta: {
      bucketDuration
    },
    aggs: {
      sum_actual: {
        sum: {
          field: 'actual'
        }
      }
    }
  };
};
const logEntryCategoryFilterBucketRT = exports.logEntryCategoryFilterBucketRT = rt.type({
  doc_count: rt.number,
  histogram_timestamp: rt.type({
    meta: rt.type({
      bucketDuration: rt.number
    }),
    buckets: rt.array(rt.type({
      key: rt.number,
      doc_count: rt.number,
      sum_actual: rt.type({
        value: rt.number
      })
    }))
  })
});
const logEntryCategoryHistogramsResponseRT = exports.logEntryCategoryHistogramsResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  aggregations: rt.type({
    filters_categories: rt.type({
      buckets: rt.record(rt.string, logEntryCategoryFilterBucketRT)
    })
  })
})]);