"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreferredSchema = getPreferredSchema;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getPreferredSchema({
  infraMetricsClient,
  dataSource,
  from,
  to,
  kuery,
  filters,
  isInventoryView = true
}) {
  const inventoryModel = (0, _common.findInventoryModel)(dataSource);

  // If the inventory model doesn't support OTel, return ECS only
  if (typeof inventoryModel.requiredIntegration !== 'object' || !('otel' in inventoryModel.requiredIntegration)) {
    return {
      schemas: ['ecs'],
      preferredSchema: 'ecs'
    };
  }
  const [ecsResponse, otelResponse] = (await infraMetricsClient.msearch([{
    track_total_hits: true,
    terminate_after: 1,
    size: 0,
    query: {
      bool: {
        should: [...(0, _server.termsQuery)(_common.EVENT_MODULE, inventoryModel.requiredIntegration.beats), ...(0, _server.termsQuery)(_common.METRICSET_MODULE, inventoryModel.requiredIntegration.beats), ...(!isInventoryView ? (0, _server.termsQuery)(_common.DATASTREAM_DATASET, 'apm*') : [])],
        minimum_should_match: 1,
        filter: [...(0, _server.rangeQuery)(from, to), ...(0, _server.kqlQuery)(kuery), ...(filters ? [filters] : [])]
      }
    }
  }, {
    track_total_hits: true,
    terminate_after: 1,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_common.DATASTREAM_DATASET, inventoryModel.requiredIntegration.otel), ...(0, _server.rangeQuery)(from, to), ...(0, _server.kqlQuery)(kuery), ...(filters ? [filters] : [])]
      }
    }
  }])).responses;
  const hasEcsData = ecsResponse.hits.total.value !== 0;
  const hasOtelData = otelResponse.hits.total.value !== 0;
  const allSchemas = ['ecs', 'semconv'];
  const availableSchemas = allSchemas.filter(key => key === 'ecs' && hasEcsData || key === 'semconv' && hasOtelData);
  const preferredSchema = availableSchemas.length > 0 ? availableSchemas.includes('semconv') ? 'semconv' : availableSchemas[0] : null;
  return {
    schemas: availableSchemas,
    preferredSchema
  };
}