"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeatures = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFeatures = homePlugin => {
  homePlugin.featureCatalogue.register({
    id: 'metrics',
    title: _i18n.i18n.translate('xpack.infra.registerFeatures.infraOpsTitle', {
      defaultMessage: 'Metrics'
    }),
    description: _i18n.i18n.translate('xpack.infra.registerFeatures.infraOpsDescription', {
      defaultMessage: 'Explore infrastructure metrics and logs for common servers, containers, and services.'
    }),
    icon: 'metricsApp',
    path: `/app/metrics`,
    showOnHomePage: false,
    category: 'data'
  });
};
exports.registerFeatures = registerFeatures;