"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerAggregationPicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _metrics_explorer = require("../../../../../common/http_api/metrics_explorer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/aggregation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsExplorerAggregationPicker = ({
  options,
  onChange
}) => {
  const AGGREGATION_LABELS = {
    ['avg']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.avg', {
      defaultMessage: 'Average'
    }),
    ['sum']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.sum', {
      defaultMessage: 'Sum'
    }),
    ['max']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.max', {
      defaultMessage: 'Max'
    }),
    ['min']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.min', {
      defaultMessage: 'Min'
    }),
    ['cardinality']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.cardinality', {
      defaultMessage: 'Cardinality'
    }),
    ['rate']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.rate', {
      defaultMessage: 'Rate'
    }),
    ['p95']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.p95', {
      defaultMessage: '95th Percentile'
    }),
    ['p99']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.p99', {
      defaultMessage: '99th Percentile'
    }),
    ['count']: _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationLabels.count', {
      defaultMessage: 'Document count'
    })
  };
  const handleChange = (0, _react.useCallback)(e => {
    const aggregation = _metrics_explorer.metricsExplorerAggregationRT.is(e.target.value) && e.target.value || 'avg';
    onChange(aggregation);
  }, [onChange]);
  const label = _i18n.i18n.translate('xpack.infra.metricsExplorer.aggregationSelectLabel', {
    defaultMessage: 'Select an aggregation'
  });
  const METRIC_EXPLORER_AGGREGATIONS_WITHOUT_CUSTOM = (0, _lodash.xor)(_metrics_explorer.METRIC_EXPLORER_AGGREGATIONS, ['custom', 'last_value']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricsExplorerAggregationPickerSelect",
    "aria-label": label,
    fullWidth: true,
    compressed: true,
    value: options.aggregation,
    options: METRIC_EXPLORER_AGGREGATIONS_WITHOUT_CUSTOM.map(k => ({
      text: AGGREGATION_LABELS[k],
      value: k
    })),
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
};
exports.MetricsExplorerAggregationPicker = MetricsExplorerAggregationPicker;