"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageBody = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _empty_states = require("../../../../components/empty_states");
var _loading = require("../../../../components/loading");
var _layout = require("./layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/page_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PageBody = ({
  loading,
  refetch,
  type,
  metrics,
  onChangeRangeTime,
  isLiveStreaming,
  stopLiveStreaming
}) => {
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      height: "100vh",
      width: "auto",
      text: _i18n.i18n.translate('xpack.infra.metrics.loadingNodeDataText', {
        defaultMessage: 'Loading data'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    });
  } else if (!loading && metrics && metrics.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoData, {
      titleText: _i18n.i18n.translate('xpack.infra.metrics.emptyViewTitle', {
        defaultMessage: 'There is no data to display.'
      }),
      bodyText: _i18n.i18n.translate('xpack.infra.metrics.emptyViewDescription', {
        defaultMessage: 'Try adjusting your time or filter.'
      }),
      refetchText: _i18n.i18n.translate('xpack.infra.metrics.refetchButtonLabel', {
        defaultMessage: 'Check for new data'
      }),
      onRefetch: refetch,
      testString: "metricsEmptyViewState",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_layout.Layout, {
    inventoryItemType: type,
    metrics: metrics,
    onChangeRangeTime: onChangeRangeTime,
    isLiveStreaming: isLiveStreaming,
    stopLiveStreaming: stopLiveStreaming,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
};
exports.PageBody = PageBody;