"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleOptionsContext = exports.useWaffleOptions = exports.WaffleOptionsProvider = exports.WaffleOptions = exports.DEFAULT_WAFFLE_OPTIONS_STATE = exports.DEFAULT_LEGEND = void 0;
var _react = require("react");
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _constate = _interopRequireDefault(require("constate"));
var _public = require("@kbn/observability-shared-plugin/public");
var _infra_ml_capabilities = require("../../../../containers/ml/infra_ml_capabilities");
var _inventory_views = require("../../../../../common/inventory_views");
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _use_inventory_views = require("./use_inventory_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LEGEND = exports.DEFAULT_LEGEND = {
  palette: 'cool',
  steps: 10,
  rules: [],
  reverseColors: false,
  type: 'gradient'
};
const DEFAULT_WAFFLE_OPTIONS_STATE = exports.DEFAULT_WAFFLE_OPTIONS_STATE = {
  metric: {
    type: 'cpuV2'
  },
  groupBy: [],
  nodeType: 'host',
  view: 'map',
  customOptions: [],
  boundsOverride: {
    max: 1,
    min: 0
  },
  autoBounds: true,
  accountId: '',
  region: '',
  customMetrics: [],
  legend: DEFAULT_LEGEND,
  source: 'default',
  sort: {
    by: 'name',
    direction: 'desc'
  },
  timelineOpen: false,
  preferredSchema: null
};
function mapInventoryViewToState(savedView) {
  const {
    metric,
    groupBy,
    nodeType,
    view,
    customOptions,
    autoBounds,
    boundsOverride,
    accountId,
    region,
    customMetrics,
    legend,
    sort,
    timelineOpen,
    preferredSchema
  } = savedView.attributes;

  // forces the default view to be set with what the time range metadata endpoint returns
  const preferredSchemaValue = nodeType === 'host' && savedView.id === _inventory_views.staticInventoryViewId ? preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : null :
  // otherwise, use the preferred schema from the saved view
  preferredSchema;
  return {
    metric,
    groupBy,
    nodeType,
    view,
    customOptions,
    autoBounds,
    boundsOverride,
    accountId,
    region,
    customMetrics,
    legend,
    sort,
    timelineOpen,
    preferredSchema: preferredSchemaValue
  };
}
const useWaffleOptions = () => {
  var _currentView$id;
  const {
    currentView
  } = (0, _use_inventory_views.useInventoryViewsContext)();
  const {
    inventoryPrefill: {
      setPrefillState
    }
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const {
    updateTopbarMenuVisibilityBySchema
  } = (0, _infra_ml_capabilities.useInfraMLCapabilitiesContext)();
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: currentView ? mapInventoryViewToState(currentView) : DEFAULT_WAFFLE_OPTIONS_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'waffleOptions',
    writeDefaultState: true
  });
  const [preferredSchema, setPreferredSchema] = (0, _react.useState)(null);
  const previousViewId = (0, _react.useRef)((_currentView$id = currentView === null || currentView === void 0 ? void 0 : currentView.id) !== null && _currentView$id !== void 0 ? _currentView$id : _inventory_views.staticInventoryViewId);
  (0, _react.useEffect)(() => {
    if (currentView && currentView.id !== previousViewId.current) {
      var _currentView$attribut;
      const state = mapInventoryViewToState(currentView);
      updateTopbarMenuVisibilityBySchema(state.preferredSchema);
      setUrlState(state);
      previousViewId.current = currentView.id;
      setPreferredSchema((_currentView$attribut = currentView === null || currentView === void 0 ? void 0 : currentView.attributes.preferredSchema) !== null && _currentView$attribut !== void 0 ? _currentView$attribut : null);
    }
  }, [currentView, setUrlState, updateTopbarMenuVisibilityBySchema]);

  // there is a lot going on with the url state management on this hook
  // when the state resets, many things need to be synchronized
  // to avoid problems, we sync the url state manually.
  (0, _react.useEffect)(() => {
    if (urlState.preferredSchema !== preferredSchema) {
      setUrlState(previous => ({
        ...previous,
        preferredSchema
      }));
    }
  }, [preferredSchema, setUrlState, urlState.preferredSchema]);
  const changeMetric = (0, _react.useCallback)(metric => setUrlState(previous => ({
    ...previous,
    metric
  })), [setUrlState]);
  const changeGroupBy = (0, _react.useCallback)(groupBy => setUrlState(previous => ({
    ...previous,
    groupBy
  })), [setUrlState]);
  const changeNodeType = (0, _react.useCallback)(nodeType => setUrlState(previous => ({
    ...previous,
    nodeType
  })), [setUrlState]);
  const changeView = (0, _react.useCallback)(view => setUrlState(previous => ({
    ...previous,
    view: view
  })), [setUrlState]);
  const changeCustomOptions = (0, _react.useCallback)(customOptions => setUrlState(previous => ({
    ...previous,
    customOptions
  })), [setUrlState]);
  const changeAutoBounds = (0, _react.useCallback)(autoBounds => setUrlState(previous => ({
    ...previous,
    autoBounds
  })), [setUrlState]);
  const changeBoundsOverride = (0, _react.useCallback)(boundsOverride => setUrlState(previous => ({
    ...previous,
    boundsOverride
  })), [setUrlState]);
  const changeAccount = (0, _react.useCallback)(accountId => setUrlState(previous => ({
    ...previous,
    accountId
  })), [setUrlState]);
  const changeRegion = (0, _react.useCallback)(region => setUrlState(previous => ({
    ...previous,
    region
  })), [setUrlState]);
  const changeCustomMetrics = (0, _react.useCallback)(customMetrics => {
    setUrlState(previous => ({
      ...previous,
      customMetrics
    }));
  }, [setUrlState]);
  const changeLegend = (0, _react.useCallback)(legend => {
    setUrlState(previous => ({
      ...previous,
      legend
    }));
  }, [setUrlState]);
  const changeSort = (0, _react.useCallback)(sort => {
    setUrlState(previous => ({
      ...previous,
      sort
    }));
  }, [setUrlState]);
  const changePreferredSchema = (0, _react.useCallback)(schema => {
    // the URL state can't be patched here because when the page reloads via clicking on the side nav
    // this will be called before the hydration of the URL state, causing the page to crash
    setPreferredSchema(schema);
    updateTopbarMenuVisibilityBySchema(schema);
  }, [setPreferredSchema, updateTopbarMenuVisibilityBySchema]);
  (0, _react.useEffect)(() => {
    setPrefillState({
      nodeType: urlState.nodeType,
      metric: urlState.metric,
      customMetrics: urlState.customMetrics,
      accountId: urlState.accountId,
      region: urlState.region,
      schema: urlState.preferredSchema
    });
  }, [setPrefillState, urlState.accountId, urlState.customMetrics, urlState.metric, urlState.nodeType, urlState.preferredSchema, urlState.region]);
  const changeTimelineOpen = (0, _react.useCallback)(timelineOpen => setUrlState(previous => ({
    ...previous,
    timelineOpen
  })), [setUrlState]);
  return {
    ...urlState,
    changeMetric,
    changeGroupBy,
    changeNodeType,
    changeView,
    changeCustomOptions,
    changeAutoBounds,
    changeBoundsOverride,
    changeAccount,
    changeRegion,
    changeCustomMetrics,
    changeLegend,
    changeSort,
    changeTimelineOpen,
    changePreferredSchema,
    setWaffleOptionsState: setUrlState
  };
};
exports.useWaffleOptions = useWaffleOptions;
const encodeUrlState = state => {
  return _inventory_views.inventoryOptionsStateRT.encode(state);
};
const decodeUrlState = value => {
  const state = (0, _pipeable.pipe)(_inventory_views.inventoryOptionsStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
  if (state) {
    state.source = 'url';
  }
  return state;
};
const WaffleOptions = exports.WaffleOptions = (0, _constate.default)(useWaffleOptions);
const [WaffleOptionsProvider, useWaffleOptionsContext] = WaffleOptions;
exports.useWaffleOptionsContext = useWaffleOptionsContext;
exports.WaffleOptionsProvider = WaffleOptionsProvider;