"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Flamegraph = Flamegraph;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _error_prompt = require("./error_prompt");
var _profiling_links = require("./profiling_links");
var _empty_data_prompt = require("./empty_data_prompt");
var _use_request_observable = require("../../hooks/use_request_observable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/profiling/flamegraph.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Flamegraph({
  kuery
}) {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    entity
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    dateRange,
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    from,
    to
  } = getDateRangeInTimestamp();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const profilingLinkLocator = services.observabilityShared.locators.profiling.flamegraphLocator;
  const profilingLinkLabel = _i18n.i18n.translate('xpack.infra.flamegraph.profilingAppFlamegraphLink', {
    defaultMessage: 'Go to Universal Profiling Flamegraph'
  });
  const params = (0, _react.useMemo)(() => ({
    kuery,
    from,
    to
  }), [from, kuery, to]);
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    return callApi('/api/infra/profiling/flamegraph', {
      method: 'GET',
      query: params
    });
  }, [params], {
    requestObservable$: request$,
    autoFetch: isActiveTab('profiling')
  });
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 12
      }
    });
  }
  if (!(0, _use_fetcher.isPending)(status) && (data === null || data === void 0 ? void 0 : data.TotalSamples) === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_data_prompt.EmptyDataPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_profiling_links.ProfilingLinks, {
    hostname: entity.name,
    from: dateRange.from,
    to: dateRange.to,
    profilingLinkLocator: profilingLinkLocator,
    profilingLinkLabel: profilingLinkLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.EmbeddableFlamegraph, {
    data: data,
    isLoading: (0, _use_fetcher.isPending)(status),
    height: "60vh",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
}