"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDashboards = EmptyDashboards;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedSvg = require("@kbn/shared-svg");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/empty_dashboards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmptyDashboards({
  actions
}) {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasShadow: false,
    hasBorder: false,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkMode ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
      alt: "",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyTitle', {
      defaultMessage: 'Want your own view?'
    })),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.first', {
      defaultMessage: 'Link your own dashboard to this view'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.second', {
      defaultMessage: 'Provide the best visualizations relevant to your business'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody', {
      defaultMessage: 'Add or remove them at any time'
    }))), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.infra.assetDetails.dashboards.emptyBody.getStarted', {
      defaultMessage: 'To get started, add your dashboard'
    }))),
    actions: actions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
}