"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnlinkDashboard = UnlinkDashboard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_custom_dashboards = require("../../../hooks/use_custom_dashboards");
var _use_fetch_custom_dashboards = require("../../../hooks/use_fetch_custom_dashboards");
var _use_asset_details_url_state = require("../../../hooks/use_asset_details_url_state");
var _use_saved_objects_permissions = require("../../../hooks/use_saved_objects_permissions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/dashboards/actions/unlink_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UnlinkDashboard({
  currentDashboard,
  onRefresh,
  assetType
}) {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    deleteCustomDashboard,
    isDeleteLoading
  } = (0, _use_custom_dashboards.useDeleteCustomDashboard)();
  const {
    dashboards,
    loading
  } = (0, _use_fetch_custom_dashboards.useFetchCustomDashboards)({
    assetType
  });
  const {
    canDelete
  } = (0, _use_saved_objects_permissions.useSavedObjectUserPermissions)();
  const onClick = (0, _react.useCallback)(() => setIsModalVisible(true), []);
  const onCancel = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const onError = (0, _react.useCallback)(() => setIsModalVisible(!isModalVisible), [isModalVisible]);
  const onConfirm = (0, _react.useCallback)(async function () {
    try {
      var _linkedDashboards$;
      const linkedDashboards = (dashboards !== null && dashboards !== void 0 ? dashboards : []).filter(({
        dashboardSavedObjectId
      }) => dashboardSavedObjectId !== currentDashboard.dashboardSavedObjectId);
      const result = await deleteCustomDashboard({
        assetType,
        id: currentDashboard.id
      });
      setUrlState({
        dashboardId: (_linkedDashboards$ = linkedDashboards[0]) === null || _linkedDashboards$ === void 0 ? void 0 : _linkedDashboards$.dashboardSavedObjectId
      });
      if (result) {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.infra.customDashboards.unlinkSuccess.toast.title', {
            defaultMessage: 'Unlinked "{dashboardName}" dashboard',
            values: {
              dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
            }
          })
        });
        onRefresh();
      }
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.infra.customDashboards.unlinkFailure.toast.title', {
          defaultMessage: 'Error while unlinking "{dashboardName}" dashboard',
          values: {
            dashboardName: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title
          }
        }),
        text: error.body.message
      });
    }
    onError();
  }, [onError, dashboards, deleteCustomDashboard, assetType, currentDashboard.id, currentDashboard.dashboardSavedObjectId, currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.title, setUrlState, notifications.toasts, onRefresh]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: !canDelete ? _i18n.i18n.translate('xpack.infra.linkDashboard.tooltip.youDoNotHavePermissionToUseThisFeature', {
      defaultMessage: 'You do not have permission to use this feature. Please ask your administrator for access.'
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "s",
    iconType: "unlink",
    "data-test-subj": "infraUnLinkDashboardMenu",
    onClick: onClick,
    disabled: !canDelete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra.customDashboards.unlinkEmptyButtonLabel', {
    defaultMessage: 'Unlink dashboard'
  }))), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.infra.customDashboards.unlinkEmptyButtonLabel.confirm.title', {
      defaultMessage: 'Unlink Dashboard'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.infra.customDashboards.unlinkEmptyButtonLabel.confirm.button', {
      defaultMessage: 'Unlink dashboard'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: loading || isDeleteLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.infra.customDashboards.unlinkEmptyButtonLabel.confirm.body', {
    defaultMessage: `You are about to unlink the dashboard from the {assetType} context`,
    values: {
      assetType
    }
  }))));
}