"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleInventoryViewRT = exports.inventoryViewRT = exports.inventoryViewOptionsRT = exports.inventoryViewBasicAttributesRT = exports.inventoryViewAttributesRT = exports.inventoryViewAttributesFilterStateRT = exports.inventorySortOptionRT = exports.inventoryOptionsStateRT = exports.inventoryMapBoundsRT = exports.inventoryFiltersStateRT = exports.inventoryColorPaletteRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _snapshot_api = require("../http_api/snapshot_api");
var _shared = require("../http_api/shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventoryColorPaletteRT = exports.inventoryColorPaletteRT = rt.keyof({
  status: null,
  temperature: null,
  cool: null,
  warm: null,
  positive: null,
  negative: null
});
const inventoryLegendTypeRT = rt.keyof({
  gradient: null,
  steps: null
});
const inventoryLegendStepRT = rt.type({
  color: rt.string,
  value: rt.number,
  label: rt.string
});
const inventoryLegendOptionsRT = rt.intersection([rt.type({
  palette: inventoryColorPaletteRT,
  steps: (0, _ioTsUtils.inRangeRt)(2, 18),
  reverseColors: rt.boolean
}), rt.partial({
  type: inventoryLegendTypeRT,
  rules: rt.array(inventoryLegendStepRT)
})]);
const inventorySortOptionRT = exports.inventorySortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
const inventoryViewOptionsRT = exports.inventoryViewOptionsRT = rt.keyof({
  table: null,
  map: null
});
const inventoryMapBoundsRT = exports.inventoryMapBoundsRT = rt.type({
  min: (0, _ioTsUtils.inRangeRt)(0, 1),
  max: (0, _ioTsUtils.inRangeRt)(0, 1)
});
const inventoryFiltersStateRT = exports.inventoryFiltersStateRT = rt.type({
  language: rt.string,
  query: rt.string
});
const inventoryOptionsStateRT = exports.inventoryOptionsStateRT = rt.intersection([rt.type({
  accountId: rt.string,
  autoBounds: rt.boolean,
  boundsOverride: inventoryMapBoundsRT,
  customMetrics: rt.array(_snapshot_api.SnapshotCustomMetricInputRT),
  customOptions: rt.array(rt.type({
    text: rt.string,
    field: rt.string
  })),
  groupBy: _snapshot_api.SnapshotGroupByRT,
  metric: _snapshot_api.SnapshotMetricInputRT,
  nodeType: _common.ItemTypeRT,
  region: rt.string,
  sort: inventorySortOptionRT,
  view: inventoryViewOptionsRT
}), rt.partial({
  legend: inventoryLegendOptionsRT,
  source: rt.string,
  timelineOpen: rt.boolean,
  preferredSchema: rt.union([_shared.DataSchemaFormatRT, rt.null])
})]);
const inventoryViewBasicAttributesRT = exports.inventoryViewBasicAttributesRT = rt.type({
  name: _ioTsUtils.nonEmptyStringRt
});
const inventoryViewFlagsRT = rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
});
const inventoryViewAttributesFilterStateRT = exports.inventoryViewAttributesFilterStateRT = rt.type({
  kind: rt.literal('kuery'),
  expression: rt.string
});
const inventoryViewAttributesRT = exports.inventoryViewAttributesRT = rt.intersection([inventoryOptionsStateRT, inventoryViewBasicAttributesRT, inventoryViewFlagsRT, rt.type({
  autoReload: rt.boolean,
  filterQuery: inventoryViewAttributesFilterStateRT
}), rt.partial({
  time: rt.number
})]);
const singleInventoryViewAttributesRT = rt.exact(rt.intersection([inventoryViewBasicAttributesRT, inventoryViewFlagsRT]));
const inventoryViewRT = exports.inventoryViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: inventoryViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
const singleInventoryViewRT = exports.singleInventoryViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: singleInventoryViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));