"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMessages = formatMessages;
exports.formatToolOptions = formatToolOptions;
var _inferenceCommon = require("@kbn/inference-common");
var _planning_tools = require("./planning_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Formats a request for the LLM by:
 * - removing all system tool calls & responses, except the last if it is a system tool
 * - Replacing `reason` tool calls and responses with `next` if power == 'low'
 * - injecting the amount of stepsLeft in the last tool response
 */

function formatMessages({
  messages,
  power,
  stepsLeft
}) {
  const lastAssistantMessageWithToolCalls = messages.findLast(message => {
    var _message$toolCalls;
    return message.role === _inferenceCommon.MessageRole.Assistant && !!((_message$toolCalls = message.toolCalls) !== null && _message$toolCalls !== void 0 && _message$toolCalls.length);
  });
  let next = messages;
  if (lastAssistantMessageWithToolCalls) {
    const indexOfLastAssistantMessage = messages.indexOf(lastAssistantMessageWithToolCalls);
    next = (0, _planning_tools.removeSystemToolCalls)(messages, indexOfLastAssistantMessage);
  }
  const lastToolResponse = next.findLast(message => message.role === _inferenceCommon.MessageRole.Tool);
  next = next.map(message => {
    if (message === lastToolResponse) {
      return {
        ...lastToolResponse,
        name: power === 'low' && message.name === 'reason' ? 'next' : message.name,
        response: {
          ...(typeof lastToolResponse.response === 'string' ? {
            content: lastToolResponse.response
          } : {}),
          stepsLeft
        }
      };
    }
    if (message.role === _inferenceCommon.MessageRole.Assistant) {
      var _message$toolCalls2;
      return {
        ...message,
        toolCalls: power === 'low' ? (_message$toolCalls2 = message.toolCalls) === null || _message$toolCalls2 === void 0 ? void 0 : _message$toolCalls2.map(toolCall => {
          if (toolCall.function.name === 'reason') {
            return {
              ...toolCall,
              function: {
                ...toolCall.function,
                name: 'next'
              }
            };
          }
          return toolCall;
        }) : message.toolCalls
      };
    }
    return message;
  });
  return next;
}
function formatToolOptions(toolOptions, power) {
  return {
    ...toolOptions,
    tools: toolOptions.tools ? Object.fromEntries(Object.entries(toolOptions.tools).map(([key, value]) => {
      if (power === 'low' && key === 'reason') {
        return ['next', _planning_tools.NEXT_TOOL];
      }
      return [key, value];
    })) : toolOptions.tools
  };
}