"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamToResponse = void 0;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamToResponse = streamResponse$ => {
  return (0, _rxjs.firstValueFrom)(streamResponse$.pipe((0, _inferenceCommon.withoutChunkEvents)(), (0, _rxjs.toArray)(), (0, _rxjs.map)(events => {
    const messageEvent = events.find(_inferenceCommon.isChatCompletionMessageEvent);
    const tokenEvent = events.find(_inferenceCommon.isChatCompletionTokenCountEvent);
    if (!messageEvent) {
      throw (0, _inferenceCommon.createInferenceInternalError)('No message event found');
    }
    return {
      content: messageEvent.content,
      refusal: messageEvent.refusal,
      toolCalls: messageEvent.toolCalls,
      tokens: tokenEvent === null || tokenEvent === void 0 ? void 0 : tokenEvent.tokens,
      deanonymized_input: messageEvent.deanonymized_input,
      deanonymized_output: messageEvent.deanonymized_output
    };
  })));
};
exports.streamToResponse = streamToResponse;