"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processVertexStream = processVertexStream;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _common = require("../../../../common");
var _errors = require("../../../../common/chat_complete/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processVertexStream(model) {
  return source => new _rxjs.Observable(subscriber => {
    function handleNext(value) {
      var _value$candidates, _value$candidates3;
      const finishReason = (_value$candidates = value.candidates) === null || _value$candidates === void 0 ? void 0 : _value$candidates[0].finishReason;
      function emitTokenCountIfApplicable() {
        var _value$usageMetadata;
        // 'usageMetadata' can be present as an empty object on chunks
        // only the last chunk will have its fields populated
        if ((_value$usageMetadata = value.usageMetadata) !== null && _value$usageMetadata !== void 0 && _value$usageMetadata.totalTokenCount) {
          subscriber.next({
            type: _inferenceCommon.ChatCompletionEventType.ChatCompletionTokenCount,
            tokens: {
              prompt: value.usageMetadata.promptTokenCount,
              completion: value.usageMetadata.candidatesTokenCount,
              cached: value.usageMetadata.cachedContentTokenCount,
              total: value.usageMetadata.totalTokenCount
            },
            ...(model ? {
              model
            } : {})
          });
        }
      }
      if (finishReason === 'UNEXPECTED_TOOL_CALL' || finishReason === 'MALFORMED_FUNCTION_CALL') {
        var _value$candidates2;
        const finishMessage = (_value$candidates2 = value.candidates) === null || _value$candidates2 === void 0 ? void 0 : _value$candidates2[0].finishMessage;
        const validationErrorMessage = finishMessage ? `${finishReason} - ${finishMessage}` : finishReason;
        emitTokenCountIfApplicable();
        subscriber.error((0, _errors.createToolValidationError)(validationErrorMessage, {
          errorsText: finishMessage,
          toolCalls: []
        }));
        return;
      }
      const contentPart = (_value$candidates3 = value.candidates) === null || _value$candidates3 === void 0 ? void 0 : _value$candidates3[0].content.parts[0];
      const completion = contentPart === null || contentPart === void 0 ? void 0 : contentPart.text;
      const toolCall = contentPart === null || contentPart === void 0 ? void 0 : contentPart.functionCall;
      if (completion || toolCall) {
        subscriber.next({
          type: _inferenceCommon.ChatCompletionEventType.ChatCompletionChunk,
          content: completion !== null && completion !== void 0 ? completion : '',
          tool_calls: toolCall ? [{
            index: 0,
            toolCallId: (0, _common.generateFakeToolCallId)(),
            function: {
              name: toolCall.name,
              arguments: JSON.stringify(toolCall.args)
            }
          }] : []
        });
      }
      emitTokenCountIfApplicable();
    }
    source.subscribe({
      next: value => {
        try {
          handleNext(value);
        } catch (error) {
          subscriber.error(error);
        }
      },
      error: err => {
        subscriber.error(err);
      },
      complete: () => {
        subscriber.complete();
      }
    });
  });
}