"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geminiAdapter = void 0;
var Gemini = _interopRequireWildcard(require("@google/generative-ai"));
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _utils = require("../../utils");
var _event_source_stream_into_observable = require("../../../util/event_source_stream_into_observable");
var _process_vertex_stream = require("./process_vertex_stream");
var _get_temperature = require("../../utils/get_temperature");
var _utils2 = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const geminiAdapter = exports.geminiAdapter = {
  chatComplete: ({
    executor,
    system,
    messages,
    toolChoice,
    tools,
    temperature = 0,
    modelName,
    abortSignal,
    metadata,
    timeout
  }) => {
    var _connector$config;
    const connector = executor.getConnector();
    const useThoughtSignature = (0, _utils2.mustUseThoughtSignature)(modelName !== null && modelName !== void 0 ? modelName : (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.defaultModel);
    return (0, _rxjs.defer)(() => {
      return executor.invoke({
        subAction: 'invokeStream',
        subActionParams: {
          messages: messagesToGemini({
            messages,
            useThoughtSignature
          }),
          systemInstruction: system,
          tools: toolsToGemini(tools),
          toolConfig: toolChoiceToConfig(toolChoice),
          ...(0, _get_temperature.getTemperatureIfValid)(temperature, {
            connector,
            modelName
          }),
          model: modelName,
          signal: abortSignal,
          stopSequences: ['\n\nHuman:'],
          ...(metadata !== null && metadata !== void 0 && metadata.connectorTelemetry ? {
            telemetryMetadata: metadata.connectorTelemetry
          } : {}),
          ...(typeof timeout === 'number' && isFinite(timeout) ? {
            timeout
          } : {})
        }
      });
    }).pipe((0, _utils.handleConnectorResponse)({
      processStream: _event_source_stream_into_observable.eventSourceStreamIntoObservable
    }), (0, _rxjs.map)(line => {
      return JSON.parse(line);
    }), (0, _process_vertex_stream.processVertexStream)(modelName));
  }
};
function toolChoiceToConfig(toolChoice) {
  if (toolChoice === _inferenceCommon.ToolChoiceType.required) {
    return {
      mode: 'ANY'
    };
  } else if (toolChoice === _inferenceCommon.ToolChoiceType.none) {
    return {
      mode: 'NONE'
    };
  } else if (toolChoice === _inferenceCommon.ToolChoiceType.auto) {
    return {
      mode: 'AUTO'
    };
  } else if (toolChoice) {
    return {
      mode: 'ANY',
      allowedFunctionNames: [toolChoice.function]
    };
  }
  return undefined;
}
function toolsToGemini(tools) {
  return tools ? [{
    functionDeclarations: Object.entries(tools !== null && tools !== void 0 ? tools : {}).map(([toolName, {
      description,
      schema
    }]) => {
      return {
        name: toolName,
        description,
        parameters: schema ? toolSchemaToGemini({
          schema
        }) : {
          type: Gemini.SchemaType.OBJECT,
          properties: {}
        }
      };
    })
  }] : [];
}
function toolSchemaToGemini({
  schema
}) {
  var _schema$properties;
  const convertSchemaType = ({
    def
  }) => {
    switch (def.type) {
      case 'array':
        return {
          type: Gemini.SchemaType.ARRAY,
          description: def.description,
          // @ts-expect-error - items is optional (empty object means any)
          items: def.items ? convertSchemaType({
            def: def.items
          }) : {}
        };
      case 'object':
        return {
          type: Gemini.SchemaType.OBJECT,
          description: def.description,
          required: def.required,
          properties: def.properties ? Object.entries(def.properties).reduce((properties, [key, prop]) => {
            properties[key] = convertSchemaType({
              def: prop
            });
            return properties;
          }, {}) : {}
        };
      case 'string':
        return {
          type: Gemini.SchemaType.STRING,
          format: 'enum',
          description: def.description,
          enum: def.enum ? def.enum : def.const ? [def.const] : []
        };
      case 'boolean':
        return {
          type: Gemini.SchemaType.BOOLEAN,
          description: def.description
        };
      case 'number':
        return {
          type: Gemini.SchemaType.NUMBER,
          description: def.description
        };
    }
  };
  return {
    type: Gemini.SchemaType.OBJECT,
    required: schema.required,
    properties: Object.entries((_schema$properties = schema.properties) !== null && _schema$properties !== void 0 ? _schema$properties : {}).reduce((properties, [key, def]) => {
      properties[key] = convertSchemaType({
        def
      });
      return properties;
    }, {})
  };
}
const skipThoughtSignatureHash = 'skip_thought_signature_validator';
function messagesToGemini({
  messages,
  useThoughtSignature
}) {
  let mapped = messages.map(messageToGeminiMapper()).reduce((output, message) => {
    // merging consecutive messages from the same user, as Gemini requires multi-turn messages
    const previousMessage = output.length ? output[output.length - 1] : undefined;
    if ((previousMessage === null || previousMessage === void 0 ? void 0 : previousMessage.role) === message.role) {
      previousMessage.parts.push(...message.parts);
    } else {
      output.push(message);
    }
    return output;
  }, []);
  if (useThoughtSignature) {
    mapped = mapped.map((message, index, array) => {
      if (index < array.length - 1) {
        addThoughtSignatureToFirstFunctionCall(message);
      }
      return message;
    });
  }
  return mapped;
}
const addThoughtSignatureToFirstFunctionCall = message => {
  for (const part of message.parts) {
    if (part.functionCall) {
      // @ts-expect-error - Gemini types are not up to date, this is a valid property
      part.thoughtSignature = skipThoughtSignatureHash;
      break;
    }
  }
};
function messageToGeminiMapper() {
  return message => {
    var _message$toolCalls;
    const role = message.role;
    switch (role) {
      case _inferenceCommon.MessageRole.Assistant:
        const assistantMessage = {
          role: 'assistant',
          parts: [...(message.content ? [{
            text: message.content
          }] : []), ...((_message$toolCalls = message.toolCalls) !== null && _message$toolCalls !== void 0 ? _message$toolCalls : []).map(toolCall => {
            return {
              functionCall: {
                name: toolCall.function.name,
                args: 'arguments' in toolCall.function ? toolCall.function.arguments : {}
              }
            };
          })]
        };
        return assistantMessage;
      case _inferenceCommon.MessageRole.User:
        const userMessage = {
          role: 'user',
          parts: (typeof message.content === 'string' ? [message.content] : message.content).map(contentPart => {
            if (typeof contentPart === 'string') {
              return {
                text: contentPart
              };
            } else if (contentPart.type === 'text') {
              return {
                text: contentPart.text
              };
            }
            return {
              inlineData: {
                data: contentPart.source.data,
                mimeType: contentPart.source.mimeType
              }
            };
          })
        };
        return userMessage;
      case _inferenceCommon.MessageRole.Tool:
        // tool responses are provided as user messages
        const toolMessage = {
          role: 'user',
          parts: [{
            functionResponse: {
              name: message.toolCallId,
              // gemini expects a structured response shape, making sure we're not sending a string
              response: typeof message.response === 'string' ? {
                response: message.response
              } : message.response
            }
          }]
        };
        return toolMessage;
    }
  };
}