"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPostIndexDocCountRoute = registerPostIndexDocCountRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerPostIndexDocCountRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.post({
    path: (0, _.addInternalBasePath)('/index_doc_count'),
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: {
      body: _configSchema.schema.object({
        indexNames: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
          minSize: 1
        })
      })
    }
  }, async (context, request, response) => {
    const client = (await context.core).elasticsearch.client.asCurrentUser;
    const {
      indexNames
    } = request.body;
    try {
      var _result$aggregations;
      const result = await client.search({
        index: indexNames,
        size: 0,
        aggs: {
          by_index: {
            terms: {
              field: '_index',
              size: indexNames.length
            }
          }
        }
      });
      const values = (((_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.by_index.buckets) || []).reduce((col, bucket) => {
        col[bucket.key] = bucket.doc_count;
        return col;
      }, {});

      // add zeros back in since they won't be present in the agg results
      indexNames.forEach(indexName => {
        if (!(indexName in values)) {
          values[indexName] = 0;
        }
      });
      return response.ok({
        body: values
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}