"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.documentationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../components/mappings_editor/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DocumentationService {
  constructor() {
    (0, _defineProperty2.default)(this, "links", void 0);
    (0, _defineProperty2.default)(this, "dataStreams", '');
    (0, _defineProperty2.default)(this, "esDocsBase", '');
    (0, _defineProperty2.default)(this, "enrichPolicies", '');
    (0, _defineProperty2.default)(this, "createEnrichPolicies", '');
    (0, _defineProperty2.default)(this, "matchAllQuery", '');
    (0, _defineProperty2.default)(this, "indexManagement", '');
    (0, _defineProperty2.default)(this, "indexSettings", '');
    (0, _defineProperty2.default)(this, "indexTemplates", '');
    (0, _defineProperty2.default)(this, "indexV1", '');
    (0, _defineProperty2.default)(this, "inferenceApisConfigureChunking", '');
    (0, _defineProperty2.default)(this, "mapping", '');
    (0, _defineProperty2.default)(this, "mappingAnalyzer", '');
    (0, _defineProperty2.default)(this, "mappingCoerce", '');
    (0, _defineProperty2.default)(this, "mappingCopyTo", '');
    (0, _defineProperty2.default)(this, "mappingDocValues", '');
    (0, _defineProperty2.default)(this, "mappingDynamic", '');
    (0, _defineProperty2.default)(this, "mappingDynamicFields", '');
    (0, _defineProperty2.default)(this, "mappingDynamicTemplates", '');
    (0, _defineProperty2.default)(this, "mappingEagerGlobalOrdinals", '');
    (0, _defineProperty2.default)(this, "mappingEnabled", '');
    (0, _defineProperty2.default)(this, "mappingFieldData", '');
    (0, _defineProperty2.default)(this, "mappingFieldDataFilter", '');
    (0, _defineProperty2.default)(this, "mappingFieldDataTypes", '');
    (0, _defineProperty2.default)(this, "mappingFieldDataEnable", '');
    (0, _defineProperty2.default)(this, "mappingFormat", '');
    (0, _defineProperty2.default)(this, "mappingIgnoreAbove", '');
    (0, _defineProperty2.default)(this, "mappingIgnoreMalformed", '');
    (0, _defineProperty2.default)(this, "mappingIndex", '');
    (0, _defineProperty2.default)(this, "mappingIndexOptions", '');
    (0, _defineProperty2.default)(this, "mappingIndexPhrases", '');
    (0, _defineProperty2.default)(this, "mappingIndexPrefixes", '');
    (0, _defineProperty2.default)(this, "mappingJoinFieldsPerformance", '');
    (0, _defineProperty2.default)(this, "mappingMeta", '');
    (0, _defineProperty2.default)(this, "mappingMetaFields", '');
    (0, _defineProperty2.default)(this, "mappingNormalizer", '');
    (0, _defineProperty2.default)(this, "mappingNorms", '');
    (0, _defineProperty2.default)(this, "mappingNullValue", '');
    (0, _defineProperty2.default)(this, "mappingParameters", '');
    (0, _defineProperty2.default)(this, "mappingPositionIncrementGap", '');
    (0, _defineProperty2.default)(this, "mappingRankFeatureFields", '');
    (0, _defineProperty2.default)(this, "mappingRouting", '');
    (0, _defineProperty2.default)(this, "mappingSimilarity", '');
    (0, _defineProperty2.default)(this, "mappingSourceFields", '');
    (0, _defineProperty2.default)(this, "mappingSourceFieldsDisable", '');
    (0, _defineProperty2.default)(this, "mappingSyntheticSourceFields", '');
    (0, _defineProperty2.default)(this, "mappingStore", '');
    (0, _defineProperty2.default)(this, "mappingSubobjects", '');
    (0, _defineProperty2.default)(this, "mappingTermVector", '');
    (0, _defineProperty2.default)(this, "mappingTypesRemoval", '');
    (0, _defineProperty2.default)(this, "percolate", '');
    (0, _defineProperty2.default)(this, "runtimeFields", '');
    (0, _defineProperty2.default)(this, "indicesComponentTemplate", '');
    (0, _defineProperty2.default)(this, "bulkIndexAlias", '');
    (0, _defineProperty2.default)(this, "indexStats", '');
    (0, _defineProperty2.default)(this, "bulkApi", '');
    (0, _defineProperty2.default)(this, "updateExistingDS", '');
    (0, _defineProperty2.default)(this, "enrichIngestData", '');
    (0, _defineProperty2.default)(this, "mappingReference", '');
    (0, _defineProperty2.default)(this, "elasticInferenceService", '');
    (0, _defineProperty2.default)(this, "elasticInferenceServicePricing", '');
    (0, _defineProperty2.default)(this, "cloudPricing", '');
    (0, _defineProperty2.default)(this, "getTypeDocLink", (type, docType = 'main') => {
      const typeDefinition = _constants.TYPE_DEFINITION[type];
      if (!typeDefinition || !typeDefinition.documentation || !typeDefinition.documentation[docType]) {
        return undefined;
      }
      return `${this.mappingReference}/${typeDefinition.documentation[docType]}`;
    });
  }
  setup(docLinks) {
    const {
      links
    } = docLinks;
    this.links = links;
    this.dataStreams = links.elasticsearch.dataStreams;
    this.esDocsBase = links.elasticsearch.docsBase;
    this.enrichPolicies = links.elasticsearch.enrichPolicies;
    this.createEnrichPolicies = links.elasticsearch.createEnrichPolicy;
    this.matchAllQuery = links.elasticsearch.matchAllQuery;
    this.indexManagement = links.management.indexManagement;
    this.indexSettings = links.elasticsearch.indexSettings;
    this.indexTemplates = links.elasticsearch.indexTemplates;
    this.inferenceApisConfigureChunking = links.enterpriseSearch.inferenceApisConfigureChunking;
    this.indexV1 = links.apis.putIndexTemplateV1;
    this.mapping = links.elasticsearch.mapping;
    this.mappingAnalyzer = links.elasticsearch.mappingAnalyzer;
    this.mappingCoerce = links.elasticsearch.mappingCoerce;
    this.mappingCopyTo = links.elasticsearch.mappingCopyTo;
    this.mappingDocValues = links.elasticsearch.mappingDocValues;
    this.mappingDynamic = links.elasticsearch.mappingDynamic;
    this.mappingDynamicFields = links.elasticsearch.mappingDynamicFields;
    this.mappingDynamicTemplates = links.elasticsearch.mappingDynamicTemplates;
    this.mappingEagerGlobalOrdinals = links.elasticsearch.mappingEagerGlobalOrdinals;
    this.mappingEnabled = links.elasticsearch.mappingEnabled;
    this.mappingFieldData = links.elasticsearch.mappingFieldData;
    this.mappingFieldDataTypes = links.elasticsearch.mappingFieldDataTypes;
    this.mappingFieldDataEnable = links.elasticsearch.mappingFieldDataEnable;
    this.mappingFieldDataFilter = links.elasticsearch.mappingFieldDataFilter;
    this.mappingFormat = links.elasticsearch.mappingFormat;
    this.mappingIgnoreAbove = links.elasticsearch.mappingIgnoreAbove;
    this.mappingIgnoreMalformed = links.elasticsearch.mappingIgnoreMalformed;
    this.mappingIndex = links.elasticsearch.mappingIndex;
    this.mappingIndexOptions = links.elasticsearch.mappingIndexOptions;
    this.mappingIndexPhrases = links.elasticsearch.mappingIndexPhrases;
    this.mappingIndexPrefixes = links.elasticsearch.mappingIndexPrefixes;
    this.mappingJoinFieldsPerformance = links.elasticsearch.mappingJoinFieldsPerformance;
    this.mappingMeta = links.elasticsearch.mappingMeta;
    this.mappingMetaFields = links.elasticsearch.mappingMetaFields;
    this.mappingNormalizer = links.elasticsearch.mappingNormalizer;
    this.mappingNorms = links.elasticsearch.mappingNorms;
    this.mappingNullValue = links.elasticsearch.mappingNullValue;
    this.mappingParameters = links.elasticsearch.mappingParameters;
    this.mappingPositionIncrementGap = links.elasticsearch.mappingPositionIncrementGap;
    this.mappingRankFeatureFields = links.elasticsearch.mappingRankFeatureFields;
    this.mappingReference = links.elasticsearch.mappingReference;
    this.mappingRouting = links.elasticsearch.mappingRouting;
    this.mappingSimilarity = links.elasticsearch.mappingSimilarity;
    this.mappingSourceFields = links.elasticsearch.mappingSourceFields;
    this.mappingSourceFieldsDisable = links.elasticsearch.mappingSourceFieldsDisable;
    this.mappingSyntheticSourceFields = links.elasticsearch.mappingSyntheticSourceFields;
    this.mappingStore = links.elasticsearch.mappingStore;
    this.mappingSubobjects = links.elasticsearch.mappingSubobjects;
    this.mappingTermVector = links.elasticsearch.mappingTermVector;
    this.mappingTypesRemoval = links.elasticsearch.mappingTypesRemoval;
    this.percolate = links.query.percolate;
    this.runtimeFields = links.runtimeFields.overview;
    this.indicesComponentTemplate = links.indexManagement.componentTemplate;
    this.bulkIndexAlias = links.indexManagement.indexAlias;
    this.indexStats = links.apis.indexStats;
    this.bulkApi = links.enterpriseSearch.bulkApi;
    this.updateExistingDS = links.elasticsearch.tutorialUpdateExistingDataStream;
    this.enrichIngestData = links.ingest.enrich;
    this.elasticInferenceService = links.enterpriseSearch.elasticInferenceService;
    this.elasticInferenceServicePricing = links.enterpriseSearch.elasticInferenceServicePricing;
    this.cloudPricing = links.cloud.cloudPricing;
  }
  getEsDocsBase() {
    return this.esDocsBase;
  }
  getSettingsDocumentationLink() {
    return this.indexSettings;
  }
  getMappingDocumentationLink() {
    return this.mapping;
  }
  getRoutingLink() {
    return this.mappingRouting;
  }
  getDataStreamsDocumentationLink() {
    return this.dataStreams;
  }
  getTemplatesDocumentationLink(isLegacy = false) {
    return isLegacy ? this.indexV1 : this.indexTemplates;
  }
  getIdxMgmtDocumentationLink() {
    return this.indexManagement;
  }
  getConfigureChunkingDocLink() {
    return this.inferenceApisConfigureChunking;
  }
  getIndicesComponentTemplate() {
    return this.indicesComponentTemplate;
  }
  getMappingTypesLink() {
    return this.mappingFieldDataTypes;
  }
  getDynamicMappingLink() {
    return this.mappingDynamicFields;
  }
  getPercolatorQueryLink() {
    return this.percolate;
  }
  getRankFeatureQueryLink() {
    return this.mappingRankFeatureFields;
  }
  getEnrichApisLink() {
    return this.enrichPolicies;
  }
  getCreateEnrichPolicyLink() {
    return this.createEnrichPolicies;
  }
  getMatchAllQueryLink() {
    return this.matchAllQuery;
  }
  getMetaFieldLink() {
    return this.mappingMetaFields;
  }
  getDynamicTemplatesLink() {
    return this.mappingDynamicTemplates;
  }
  getMappingSourceFieldLink() {
    return this.mappingSourceFields;
  }
  getDisablingMappingSourceFieldLink() {
    return this.mappingSourceFieldsDisable;
  }
  getMappingSyntheticSourceFieldLink() {
    return this.mappingSyntheticSourceFields;
  }
  getNullValueLink() {
    return this.mappingNullValue;
  }
  getTermVectorLink() {
    return this.mappingTermVector;
  }
  getStoreLink() {
    return this.mappingStore;
  }
  getSimilarityLink() {
    return this.mappingSimilarity;
  }
  getNormsLink() {
    return this.mappingNorms;
  }
  getIndexLink() {
    return this.mappingIndex;
  }
  getIgnoreMalformedLink() {
    return this.mappingIgnoreMalformed;
  }
  getMetaLink() {
    return this.mappingMeta;
  }
  getFormatLink() {
    return this.mappingFormat;
  }
  getEagerGlobalOrdinalsLink() {
    return this.mappingEagerGlobalOrdinals;
  }
  getDocValuesLink() {
    return this.mappingDocValues;
  }
  getCopyToLink() {
    return this.mappingCopyTo;
  }
  getCoerceLink() {
    return this.mappingCoerce;
  }
  getBoostLink() {
    return this.mappingParameters;
  }
  getNormalizerLink() {
    return this.mappingNormalizer;
  }
  getIgnoreAboveLink() {
    return this.mappingIgnoreAbove;
  }
  getFielddataLink() {
    return this.mappingFieldData;
  }
  getFielddataFrequencyLink() {
    return this.mappingFieldDataFilter;
  }
  getEnablingFielddataLink() {
    return this.mappingFieldDataEnable;
  }
  getIndexPhrasesLink() {
    return this.mappingIndexPhrases;
  }
  getIndexPrefixesLink() {
    return this.mappingIndexPrefixes;
  }
  getPositionIncrementGapLink() {
    return this.mappingPositionIncrementGap;
  }
  getAnalyzerLink() {
    return this.mappingAnalyzer;
  }
  getDateFormatLink() {
    return this.mappingFormat;
  }
  getIndexOptionsLink() {
    return this.mappingIndexOptions;
  }
  getAlternativeToMappingTypesLink() {
    return this.mappingTypesRemoval;
  }
  getJoinMultiLevelsPerformanceLink() {
    return this.mappingJoinFieldsPerformance;
  }
  getDynamicLink() {
    return this.mappingDynamic;
  }
  getEnabledLink() {
    return this.mappingEnabled;
  }
  getSubobjectsLink() {
    return this.mappingSubobjects;
  }
  getRuntimeFields() {
    return this.runtimeFields;
  }
  getBulkIndexAlias() {
    return this.bulkIndexAlias;
  }
  getIndexStats() {
    return this.indexStats;
  }
  getBulkApi() {
    return this.bulkApi;
  }
  getUpdateExistingDS() {
    return this.updateExistingDS;
  }
  getEnrichIngestDataLink() {
    return this.enrichIngestData;
  }
  getEisDocumentationLink() {
    return this.elasticInferenceService;
  }
  getEisPricingDocumentationLink() {
    return this.elasticInferenceServicePricing;
  }
  getCloudPricing() {
    return this.cloudPricing;
  }
  getWellKnownTextLink() {
    return 'http://docs.opengeospatial.org/is/12-063r5/12-063r5.html';
  }
  getRootLocaleLink() {
    return 'https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html#ROOT';
  }
  get docLinks() {
    if (!this.links) {
      throw new Error(`Can't return undefined doc links.`);
    }
    return this.links;
  }
}
const documentationService = exports.documentationService = new DocumentationService();