"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.docCountApi = exports.RequestResultType = void 0;
var _rxjs = require("rxjs");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RequestResultType = exports.RequestResultType = /*#__PURE__*/function (RequestResultType) {
  RequestResultType["Success"] = "success";
  RequestResultType["Error"] = "error";
  return RequestResultType;
}({});
const docCountApi = httpSetup => {
  const subj = new _rxjs.Subject();
  const abortController = new AbortController();
  const observable = subj.pipe(
  // Buffer indices for 100ms before making a request
  (0, _rxjs.bufferTime)(100),
  // filter out empty arrays
  (0, _rxjs.filter)(indices => indices.length > 0),
  // make a request for each batch of indices
  (0, _rxjs.concatMap)(indexNames => (0, _rxjs.from)(httpSetup.post(`${_constants.INTERNAL_API_BASE_PATH}/index_doc_count`, {
    body: JSON.stringify({
      indexNames
    }),
    signal: abortController.signal
  })).pipe((0, _rxjs.map)(response => ({
    type: RequestResultType.Success,
    indexNames,
    response
  })), (0, _rxjs.catchError)(() => {
    // Avoid showing errors when navigating away; IndexTable aborts in componentWillUnmount.
    if (abortController.signal.aborted) {
      return _rxjs.EMPTY;
    }
    return (0, _rxjs.of)({
      type: RequestResultType.Error,
      indexNames
    });
  }))),
  // combine all the responses into a single object (but keep per-index error state)
  (0, _rxjs.scan)((acc, result) => {
    const next = {
      ...acc
    };
    if (result.type === RequestResultType.Error) {
      // If the request fails, mark only indices in that request as errored.
      for (const indexName of result.indexNames) {
        next[indexName] = next[indexName] || {
          status: RequestResultType.Error
        };
      }
      return next;
    } else {
      for (const indexName of result.indexNames) {
        var _result$response$inde;
        next[indexName] = {
          status: RequestResultType.Success,
          count: (_result$response$inde = result.response[indexName]) !== null && _result$response$inde !== void 0 ? _result$response$inde : 0
        };
      }
      return next;
    }
  }, {}),
  // share the observable so it can be used multiple times
  (0, _rxjs.share)());
  return {
    getByName: index => subj.next(index),
    getObservable: () => observable,
    abort: () => abortController.abort()
  };
};
exports.docCountApi = docCountApi;