"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionsContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _flatten_panel_tree = require("../../../../lib/flatten_panel_tree");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../services/routing");
var _app_context = require("../../../../app_context");
var _modal_host = require("./modal_host/modal_host");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/index_actions_context_menu/index_actions_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexActionsContextMenu = ({
  indexNames,
  indices,
  isOnListView,
  resetSelection,
  anchorPosition = 'rightUp',
  iconSide = 'right',
  iconType = 'arrowDown',
  label,
  closeIndices,
  openIndices,
  flushIndices,
  refreshIndices,
  clearCacheIndices,
  forcemergeIndices,
  deleteIndices,
  indexStatusByName,
  performExtensionAction,
  reloadIndices,
  fill = true,
  isLoading = false,
  indicesListURLParams = ''
}) => {
  const {
    services: {
      extensionsService
    },
    plugins: {
      reindexService
    },
    core: {
      getUrlForApp,
      application,
      http
    },
    history,
    config: {
      enableIndexActions
    }
  } = (0, _app_context.useAppContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const modalRef = (0, _react.useRef)(null);
  const onButtonClick = () => {
    setIsPopoverOpen(prevState => !prevState);
  };
  const closePopoverAndExecute = func => {
    setIsPopoverOpen(false);
    func();
    resetSelection === null || resetSelection === void 0 ? void 0 : resetSelection();
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const isConvertableToLookupIndex = indexName => {
    const selectedIndex = indices.find(index => index.name === indexName);
    if (!selectedIndex || selectedIndex.documents === undefined || selectedIndex.primary === undefined) {
      return false;
    }
    if (selectedIndex.documents >= 0 && selectedIndex.documents <= _constants.MAX_DOCUMENTS_FOR_CONVERT_TO_LOOKUP_INDEX && Number(selectedIndex.primary) === _constants.MAX_SHARDS_FOR_CONVERT_TO_LOOKUP_INDEX) {
      return true;
    }
    return false;
  };
  const getPanels = () => {
    const allOpen = (0, _lodash.every)(indexNames, indexName => {
      return indexStatusByName[indexName] === _constants.INDEX_OPEN;
    });
    const selectedIndexCount = indexNames.length;
    const items = [];
    if (isOnListView && selectedIndexCount === 1) {
      items.push({
        'data-test-subj': 'showOverviewIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexOverviewLabel', {
          defaultMessage: 'Show index overview'
        }),
        onClick: () => {
          closePopoverAndExecute(() => {
            (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Overview);
          });
        }
      });
      items.push({
        'data-test-subj': 'showSettingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexSettingsLabel', {
          defaultMessage: 'Show index settings'
        }),
        onClick: () => {
          closePopoverAndExecute(() => {
            (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Settings);
          });
        }
      });
      items.push({
        'data-test-subj': 'showMappingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexMappingLabel', {
          defaultMessage: 'Show index mapping'
        }),
        onClick: () => {
          closePopoverAndExecute(() => {
            (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Mappings);
          });
        }
      });
      if (allOpen && enableIndexActions) {
        items.push({
          'data-test-subj': 'showStatsIndexMenuButton',
          name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexStatsLabel', {
            defaultMessage: 'Show index stats'
          }),
          onClick: () => {
            history.push((0, _routing.getIndexDetailsLink)(indexNames[0], indicesListURLParams, _constants.IndexDetailsSection.Stats));
          }
        });
      }
    }
    if (allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'closeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.closeIndexLabel', {
          defaultMessage: 'Close {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          closePopoverAndExecute(closeIndices);
        }
      });
      items.push({
        'data-test-subj': 'forcemergeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMergeIndexLabel', {
          defaultMessage: 'Force merge {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          var _modalRef$current;
          closePopover();
          (_modalRef$current = modalRef.current) === null || _modalRef$current === void 0 ? void 0 : _modalRef$current.openModal({
            kind: 'forcemerge'
          });
        }
      });
      items.push({
        'data-test-subj': 'refreshIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.refreshIndexLabel', {
          defaultMessage: 'Refresh {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          closePopoverAndExecute(refreshIndices);
        }
      });
      items.push({
        'data-test-subj': 'clearCacheIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.clearIndexCacheLabel', {
          defaultMessage: 'Clear {selectedIndexCount, plural, one {index} other {indices} } cache',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          closePopoverAndExecute(clearCacheIndices);
        }
      });
      items.push({
        'data-test-subj': 'flushIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.flushIndexLabel', {
          defaultMessage: 'Flush {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          closePopoverAndExecute(flushIndices);
        }
      });
    } else if (!allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'openIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.openIndexLabel', {
          defaultMessage: 'Open {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          closePopoverAndExecute(openIndices);
        }
      });
    }
    items.push({
      'data-test-subj': 'deleteIndexMenuButton',
      name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndexLabel', {
        defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
        values: {
          selectedIndexCount
        }
      }),
      onClick: () => {
        var _modalRef$current2;
        closePopover();
        (_modalRef$current2 = modalRef.current) === null || _modalRef$current2 === void 0 ? void 0 : _modalRef$current2.openModal({
          kind: 'delete'
        });
      }
    });
    extensionsService.actions.forEach((actionExtension, actionIndex) => {
      const actionExtensionDefinition = actionExtension({
        indices,
        reloadIndices,
        getUrlForApp
      });
      if (actionExtensionDefinition) {
        const {
          buttonLabel,
          requestMethod,
          successMessage,
          renderConfirmModal
        } = actionExtensionDefinition;
        if (requestMethod) {
          items.push({
            name: buttonLabel,
            onClick: () => {
              closePopoverAndExecute(async () => {
                await performExtensionAction(requestMethod, successMessage);
              });
            }
          });
        } else if (renderConfirmModal) {
          items.push({
            name: buttonLabel,
            onClick: () => {
              var _modalRef$current3;
              closePopover();
              (_modalRef$current3 = modalRef.current) === null || _modalRef$current3 === void 0 ? void 0 : _modalRef$current3.openModal({
                kind: 'extension',
                actionIndex
              });
            }
          });
        }
      }
    });
    if (selectedIndexCount === 1) {
      const indexName = indexNames[0];
      const isConvertable = isConvertableToLookupIndex(indexName);
      const selectedIndex = indices.find(index => index.name === indexName);

      // Only show the "Convert to lookup index" action if the reindexService plugin is available,
      // the index is not already a lookup index and the index is not hidden
      if (reindexService && (selectedIndex === null || selectedIndex === void 0 ? void 0 : selectedIndex.mode) !== 'lookup' && !(selectedIndex !== null && selectedIndex !== void 0 && selectedIndex.hidden)) {
        items.push({
          'data-test-subj': 'convertToLookupIndexButton',
          name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 341,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexActionsMenu.convertToLookupIndexButton",
            defaultMessage: "Convert to lookup index",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 342,
              columnNumber: 17
            }
          })), !isConvertable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
            size: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 349,
              columnNumber: 19
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 350,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexActionsMenu.convertToLookupIndexButton.error",
            defaultMessage: "The index must have less than 2 billion documents and a single shard to be converted.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 351,
              columnNumber: 21
            }
          })))),
          disabled: !isConvertable,
          onClick: () => {
            var _modalRef$current4;
            closePopover();
            (_modalRef$current4 = modalRef.current) === null || _modalRef$current4 === void 0 ? void 0 : _modalRef$current4.openModal({
              kind: 'convertToLookup'
            });
          }
        });
      }
    }
    const panelTree = {
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.panelTitle', {
        defaultMessage: '{selectedIndexCount, plural, one {Index} other {Indices} } options',
        values: {
          selectedIndexCount
        }
      }),
      items
    };
    return (0, _flatten_panel_tree.flattenPanelTree)(panelTree);
  };
  const selectedIndexCount = indexNames.length;
  const panels = getPanels();
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "indexActionsContextMenuButton",
    iconSide: iconSide,
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.manageButtonAriaLabel', {
      defaultMessage: 'Manage {selectedIndexCount, plural, one {index} other {{selectedIndexCount} indices}}',
      values: {
        selectedIndexCount
      }
    }),
    onClick: onButtonClick,
    iconType: iconType,
    fill: fill,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 5
    }
  }, label ? label : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexActionsMenu.manageButtonLabel",
    defaultMessage: "Manage {selectedIndexCount, plural, one {index} other {{selectedIndexCount} indices}}",
    values: {
      selectedIndexCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_modal_host.ModalHost, {
    ref: modalRef,
    indexNames: indexNames,
    indices: indices,
    indicesListURLParams: indicesListURLParams,
    resetSelection: resetSelection,
    forcemergeIndices: forcemergeIndices,
    deleteIndices: deleteIndices,
    reloadIndices: reloadIndices,
    extensionsService: extensionsService,
    getUrlForApp: getUrlForApp,
    application: application,
    http: http,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenuIndices",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: anchorPosition,
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    "data-test-subj": "indexContextMenu",
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 9
    }
  })));
};
exports.IndexActionsContextMenu = IndexActionsContextMenu;