"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateElserMappingsModal = UpdateElserMappingsModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../../../../../components/mappings_editor/lib/utils");
var _mappings_state_context = require("../../../../../components/mappings_editor/mappings_state_context");
var _services = require("../../../../../services");
var _api = require("../../../../../services/api");
var _notification = require("../../../../../services/notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/update_elser_mappings/update_elser_mappings_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UpdateElserMappingsModal({
  indexName,
  refetchMapping,
  setIsModalOpen,
  hasUpdatePrivileges,
  modalId
}) {
  const state = (0, _mappings_state_context.useMappingsState)();
  const [options, setOptions] = (0, _react.useState)([]);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const isApplyDisabled = options.every(o => o.checked !== 'on') || hasUpdatePrivileges === false;
  const buildElserOptions = mappings => {
    const elserMappings = Object.values(mappings.byId).filter(_utils.isElserOnMlNodeSemanticField);
    return elserMappings.map(field => ({
      label: field.path.join('.'),
      name: field.source.name,
      key: field.id,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        iconType: "tokenSemanticText",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 16
        }
      }),
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }, field.source.inference_id)
    }));
  };
  const renderMappingOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, option.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      className: "eui-displayBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, option.label || '')));
  }, []);
  const handleError = error => {
    const errorToastTitle = _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.error.title', {
      defaultMessage: 'Error updating mappings'
    });
    const errorMessage = error ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.error.message', {
      defaultMessage: '{error}',
      values: {
        error
      }
    }) : _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.error.defaultMessage', {
      defaultMessage: 'Mappings could not be updated. Please try again.'
    });
    _notification.notificationService.showDangerToast(errorToastTitle, errorMessage);
  };
  const handleApply = (0, _react.useCallback)(async () => {
    setIsUpdating(true);
    const selectedOptions = options.filter(option => option.checked === 'on');
    const selectedFields = (0, _utils.prepareFieldsForEisUpdate)(selectedOptions, state.mappingViewFields);
    const denormalizedFields = (0, _utils.deNormalize)(selectedFields);
    try {
      const {
        error
      } = await (0, _api.updateIndexMappings)(indexName, denormalizedFields);
      if (!error) {
        _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.successfullyUpdatedIndexMappingsTitle', {
          defaultMessage: 'Mappings updated'
        }), _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.successfullyUpdatedIndexMappingsText', {
          defaultMessage: 'Your index mappings have been updated.'
        }));
        refetchMapping();
      } else {
        handleError(error.message);
      }
    } catch (exception) {
      handleError(exception.message);
    } finally {
      setIsUpdating(false);
      setIsModalOpen(false);
    }
  }, [indexName, refetchMapping, options, setIsModalOpen, state.mappingViewFields]);
  (0, _react.useEffect)(() => {
    const elserOptions = buildElserOptions(state.mappingViewFields);
    if (elserOptions) setOptions(elserOptions);
  }, [state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    style: {
      width: 600
    },
    "aria-labelledby": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.ariaLabelledBy', {
      defaultMessage: 'Update mappings to ELSER on EIS modal'
    }),
    onClose: () => setIsModalOpen(false),
    "data-test-subj": "updateElserMappingsModal",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.title', {
    defaultMessage: 'Update mappings to ELSER on EIS'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.costsTransparency', {
    defaultMessage: 'Performing inference and other ML tasks using the Elastic Inference Service (EIS) will incur token-based costs.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": `${modalId}-updateElserMappingsModal-learnMore-link`,
    href: _services.documentationService.docLinks.enterpriseSearch.elasticInferenceServicePricing,
    target: "_blank",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.learnMoreLink', {
    defaultMessage: 'Learn more'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "updateElserMappingsSelect",
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.select', {
      defaultMessage: 'Select ELSER mappings'
    }),
    options: options,
    listProps: {
      bordered: true,
      isVirtualized: true,
      rowHeight: 50
    },
    onChange: newOptions => setOptions(newOptions),
    renderOption: renderMappingOption,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, list => list), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.updateConditions', {
    defaultMessage: 'Only fields using .elser-2-elasticsearch can be updated to use .elser-2-elastic on the Elastic Inference Service.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "UpdateElserMappingsModalCancelBtn",
    "data-telemetry-id": `${modalId}-updateElserMappingsModal-cancel-btn`,
    onClick: () => setIsModalOpen(false),
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel and close modal'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleApply,
    isLoading: isUpdating,
    "data-test-subj": "UpdateElserMappingsModalApplyBtn",
    "data-telemetry-id": `${modalId}-updateElserMappingsModal-apply-btn`,
    isDisabled: isApplyDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.updateElserMappingsModal.applyButton', {
    defaultMessage: 'Apply'
  })))));
}