"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _details_page_mappings_content = require("./details_page_mappings_content");
var _services = require("../../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_mappings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetailsPageMappings = ({
  index,
  showAboutMappings = true,
  hasUpdateMappingsPrivilege
}) => {
  const {
    isLoading,
    data,
    error,
    resendRequest
  } = (0, _services.useLoadIndexMappings)((index === null || index === void 0 ? void 0 : index.name) || '');
  const [jsonError, setJsonError] = (0, _react.useState)(false);
  const stringifiedData = (0, _react.useMemo)(() => {
    if (data) {
      try {
        setJsonError(false);
        return JSON.stringify(data, null, 2);
      } catch (e) {
        setJsonError(true);
      }
    }
  }, [data]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.loadingDescription",
      defaultMessage: "Loading index mappings\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }));
  }
  if (error || jsonError || !stringifiedData || !(index !== null && index !== void 0 && index.name)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsMappingsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.errorTitle",
        defaultMessage: "Unable to load index mappings",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.errorDescription",
        defaultMessage: "We encountered an error loading mappings for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName: (index === null || index === void 0 ? void 0 : index.name) || undefined
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "indexDetailsMappingsReloadButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.reloadButtonLabel",
        defaultMessage: "Reload",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 15
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_mappings_content.DetailsPageMappingsContent, {
    index: index,
    data: stringifiedData,
    jsonData: data,
    showAboutMappings: showAboutMappings,
    refetchMapping: resendRequest,
    hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  });
};
exports.DetailsPageMappings = DetailsPageMappings;