"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInferenceId = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchApiPanels = require("@kbn/search-api-panels");
var _use_compatible_inference_endpoints = require("../../../../../../hooks/use_compatible_inference_endpoints");
var _lib = require("../../../lib");
var _app_context = require("../../../../../app_context");
var _api = require("../../../../../services/api");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/select_inference_id.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceFlyoutWrapper = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/inference-endpoint-ui-common'))));
const SelectInferenceId = ({
  'data-test-subj': dataTestSubj
}) => {
  const config = (0, _lib.getFieldConfig)('inference_id');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "inference_id",
    fieldConfig: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, field => {
    return /*#__PURE__*/_react.default.createElement(SelectInferenceIdContent, {
      "data-test-subj": dataTestSubj,
      value: field.value,
      setValue: field.setValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    });
  });
};
exports.SelectInferenceId = SelectInferenceId;
const SelectInferenceIdContent = ({
  'data-test-subj': dataTestSubj,
  setValue,
  value
}) => {
  var _share$url$locators$g, _options$find, _cloud$isCloudEnabled;
  const {
    core: {
      application,
      http
    },
    config: {
      enforceAdaptiveAllocations
    },
    services: {
      notificationService: {
        toasts
      }
    },
    docLinks,
    plugins: {
      cloud,
      share
    }
  } = (0, _app_context.useAppContext)();
  const {
    isLoading: endpointsLoading,
    data: endpoints,
    resendRequest
  } = (0, _api.useLoadInferenceEndpoints)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    compatibleEndpoints,
    isLoading: isCompatibleEndpointsLoading
  } = (0, _use_compatible_inference_endpoints.useCompatibleInferenceEndpoints)(endpoints, endpointsLoading);
  const [isSelectInferenceIdOpen, setIsSelectInferenceIdOpen] = (0, _react.useState)(false);
  const [isInferenceFlyoutVisible, setIsInferenceFlyoutVisible] = (0, _react.useState)(false);
  const [isInferencePopoverVisible, setIsInferencePopoverVisible] = (0, _react.useState)(false);
  const config = (0, _lib.getFieldConfig)('inference_id');
  const inferenceEndpointsPageLink = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_INFERENCE_ENDPOINTS')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsInferenceFlyoutVisible(false);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsInferencePopoverVisible(false);
  }, []);
  const onSubmitSuccess = (0, _react.useCallback)(newEndpointId => {
    resendRequest();
    setValue(newEndpointId);
  }, [resendRequest, setValue]);

  /**
   * Computes the selectable options for the inference endpoint dropdown.
   * Only includes endpoints compatible with semantic_text (text_embedding and sparse_embedding).
   * Includes optimistic updates for newly created endpoints that may not be in the list yet.
   */
  const options = (0, _react.useMemo)(() => {
    var _compatibleEndpoints$;
    const selectableOptions = (compatibleEndpoints === null || compatibleEndpoints === void 0 ? void 0 : (_compatibleEndpoints$ = compatibleEndpoints.endpointDefinitions) === null || _compatibleEndpoints$ === void 0 ? void 0 : _compatibleEndpoints$.map(endpoint => {
      return {
        label: endpoint.inference_id,
        'data-test-subj': `custom-inference_${endpoint.inference_id}`,
        checked: value === endpoint.inference_id ? 'on' : undefined,
        disabled: !endpoint.accessible,
        append: !endpoint.accessible && endpoint.requiredLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          iconType: "lock",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 13
          }
        }, endpoint.requiredLicense[0].toUpperCase() + endpoint.requiredLicense.slice(1)),
        'aria-label': !endpoint.accessible && endpoint.requiredLicense ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.disabledOption.ariaLabel', {
          defaultMessage: '{inferenceId} endpoint disabled - {license} license required',
          values: {
            inferenceId: endpoint.inference_id,
            license: endpoint.requiredLicense
          }
        }) : undefined
      };
    })) || [];

    // Optimistic update: if a value is set but not in the list, add it
    // (handles race condition where backend hasn't updated yet after creating a new endpoint)
    const isValueInOptions = selectableOptions.some(option => option.label === value);
    if (value && !isValueInOptions) {
      selectableOptions.push({
        label: value,
        checked: 'on',
        'data-test-subj': `custom-inference_${value}`
      });
    }
    return selectableOptions;
  }, [compatibleEndpoints, value]);
  const selectedOptionLabel = (_options$find = options.find(option => option.checked)) === null || _options$find === void 0 ? void 0 : _options$find.label;

  /**
   * Auto-select default inference endpoint when:
   * - No endpoint is currently selected (!value)
   * - Endpoints have been loaded (endpoints?.length)
   * This ensures a good default UX without requiring manual selection.
   */
  (0, _react.useEffect)(() => {
    if (!value && compatibleEndpoints !== null && compatibleEndpoints !== void 0 && compatibleEndpoints.defaultInferenceId) {
      setValue(compatibleEndpoints === null || compatibleEndpoints === void 0 ? void 0 : compatibleEndpoints.defaultInferenceId);
    }
  }, [value, setValue, compatibleEndpoints]);

  /**
   * Sets state to indicate the dropdown select is open after a delay to match animation timing.
   * This ensures the InferenceCostsTransparencyTour component displays in the right place after the initial
   * animation completes.
   */
  (0, _react.useEffect)(() => {
    var _euiTheme$animation$n;
    const delay = parseInt((_euiTheme$animation$n = euiTheme.animation.normal) !== null && _euiTheme$animation$n !== void 0 ? _euiTheme$animation$n : '0', 10);
    const timeout = window.setTimeout(() => {
      setIsSelectInferenceIdOpen(true);
    }, delay);
    return () => clearTimeout(timeout);
  }, [euiTheme.animation.normal]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "selectInferenceId",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 21
      }
    }, config.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.InferenceCostsTransparencyTour, {
      promoId: "selectInferenceId",
      ctaLink: _shared_imports.documentationService.getCloudPricing(),
      isCloudEnabled: (_cloud$isCloudEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) !== null && _cloud$isCloudEnabled !== void 0 ? _cloud$isCloudEnabled : false,
      isReady: isSelectInferenceIdOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      "data-test-subj": "inferenceIdButton",
      onClick: () => {
        setIsInferencePopoverVisible(prev => !prev);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 19
      }
    }, selectedOptionLabel || _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.alreadyExistsLabel', {
      defaultMessage: 'No inference endpoint selected'
    })))),
    isOpen: isInferencePopoverVisible,
    panelPaddingSize: "none",
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createInferenceEndpointButton",
    icon: "plusInCircle",
    size: "s",
    "data-test-subj": "createInferenceEndpointButton",
    onClick: e => {
      e.preventDefault();
      setIsInferenceFlyoutVisible(true);
      setIsInferencePopoverVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.createInferenceEndpointButton', {
    defaultMessage: 'Add inference endpoint'
  })), inferenceEndpointsPageLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "manageInferenceEndpointButton",
    icon: "gear",
    size: "s",
    "data-test-subj": "manageInferenceEndpointButton",
    href: inferenceEndpointsPageLink,
    onClick: e => {
      e.preventDefault();
      application.navigateToUrl(inferenceEndpointsPageLink);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.manageInferenceEndpointButton', {
    defaultMessage: 'Manage Inference Endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.Label', {
      defaultMessage: 'Existing endpoints'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.ariaLabel', {
      defaultMessage: 'Existing endpoints'
    }),
    "data-test-subj": dataTestSubj,
    searchable: true,
    isLoading: isCompatibleEndpointsLoading,
    singleSelection: "always",
    defaultChecked: true,
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.placeholder', {
        defaultMessage: 'Search'
      })
    },
    options: options,
    onChange: newOptions => {
      var _newOptions$find;
      setValue(((_newOptions$find = newOptions.find(option => option.checked)) === null || _newOptions$find === void 0 ? void 0 : _newOptions$find.label) || '');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 19
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 25
    }
  }), list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 39
      }
    }),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.inferenceManagement.inferenceAPIDocumentation,
    target: "_blank",
    "data-test-subj": "learn-how-to-create-inference-endpoints",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.learnHowToCreateInferenceEndpoints', {
    defaultMessage: 'Learn how to create inference endpoints'
  })))), isInferenceFlyoutVisible && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 33
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: false,
    onSubmitSuccess: onSubmitSuccess,
    enforceAdaptiveAllocations: enforceAdaptiveAllocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
    defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
  })))))));
};