"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Rollover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_texts = require("../../../edit_policy/i18n_texts");
var _action_description = require("./action_description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/policy_flyout/components/rollover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Rollover = ({
  phase,
  phases
}) => {
  const phaseConfig = phases[phase];
  const rollover = phaseConfig === null || phaseConfig === void 0 ? void 0 : phaseConfig.actions.rollover;
  const descriptionItems = [];
  if (rollover !== null && rollover !== void 0 && rollover.max_primary_shard_size) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxPrimaryShardSizeLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, rollover.max_primary_shard_size)));
  }
  if (rollover !== null && rollover !== void 0 && rollover.max_primary_shard_docs) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxPrimaryShardDocsLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 9
      }
    }, rollover.max_primary_shard_docs)));
  }
  if (rollover !== null && rollover !== void 0 && rollover.max_age) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxAgeLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, rollover.max_age)));
  }
  if (rollover !== null && rollover !== void 0 && rollover.max_docs) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxDocsLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, rollover.max_docs)));
  }
  if (rollover !== null && rollover !== void 0 && rollover.max_size) {
    descriptionItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_i18n_texts.i18nTexts.editPolicy.maxSizeLabel}: `, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, rollover.max_size), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.policyFlyout.deprecatedLabel",
      defaultMessage: "Deprecated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }))));
  }
  return rollover ? /*#__PURE__*/_react.default.createElement(_action_description.ActionDescription, {
    title: _i18n_texts.i18nTexts.editPolicy.rolloverLabel,
    descriptionItems: descriptionItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }) : null;
};
exports.Rollover = Rollover;