"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTierAllocation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../../shared_imports");
var _form = require("../../../../../form");
var _node_allocation = require("./node_allocation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/data_tier_allocation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    controlSection: (0, _react2.css)`
      background-color: ${euiTheme.colors.lightestShade};
      padding-top: ${euiTheme.size.m};
      padding-left: ${euiTheme.size.m};
      padding-right: ${euiTheme.size.m};
      padding-bottom: ${euiTheme.size.m};
    `
  };
};
const customTexts = {
  inputDisplay: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.customOption.input', {
    defaultMessage: 'Custom'
  }),
  helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.customOption.helpText', {
    defaultMessage: 'Move data based on node attributes.'
  })
};
const i18nTexts = {
  allocationOptions: {
    warm: {
      default: {
        input: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.warm.defaultOption.input', {
          defaultMessage: 'Use warm nodes (recommended)'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.warm.defaultOption.helpText', {
          defaultMessage: 'Move data to nodes in the warm tier.'
        })
      },
      none: {
        inputDisplay: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.warm.noneOption.input', {
          defaultMessage: 'Off'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.warm.noneOption.helpText', {
          defaultMessage: 'Do not move data in the warm phase.'
        })
      },
      custom: customTexts
    },
    cold: {
      default: {
        input: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.cold.defaultOption.input', {
          defaultMessage: 'Use cold nodes (recommended)'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.cold.defaultOption.helpText', {
          defaultMessage: 'Move data to nodes in the cold tier.'
        })
      },
      none: {
        inputDisplay: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.cold.noneOption.input', {
          defaultMessage: 'Off'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.cold.noneOption.helpText', {
          defaultMessage: 'Do not move data in the cold phase.'
        })
      },
      custom: customTexts
    },
    frozen: {
      default: {
        input: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.frozen.defaultOption.input', {
          defaultMessage: 'Use frozen nodes (recommended)'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.frozen.defaultOption.helpText', {
          defaultMessage: 'Move data to nodes in the frozen tier.'
        })
      },
      none: {
        inputDisplay: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.frozen.noneOption.input', {
          defaultMessage: 'Off'
        }),
        helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.common.dataTierAllocation.frozen.noneOption.helpText', {
          defaultMessage: 'Do not move data in the frozen phase.'
        })
      },
      custom: customTexts
    }
  }
};
const getSelectOptions = (phase, disableDataTierOption) => [disableDataTierOption ? undefined : {
  'data-test-subj': 'defaultDataAllocationOption',
  value: 'node_roles',
  inputDisplay: i18nTexts.allocationOptions[phase].default.input,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, i18nTexts.allocationOptions[phase].default.input), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, i18nTexts.allocationOptions[phase].default.helpText)))
}, {
  'data-test-subj': 'customDataAllocationOption',
  value: 'node_attrs',
  inputDisplay: i18nTexts.allocationOptions[phase].custom.inputDisplay,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, i18nTexts.allocationOptions[phase].custom.inputDisplay), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, i18nTexts.allocationOptions[phase].custom.helpText)))
}, {
  'data-test-subj': 'noneDataAllocationOption',
  value: 'none',
  inputDisplay: i18nTexts.allocationOptions[phase].none.inputDisplay,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, i18nTexts.allocationOptions[phase].none.inputDisplay), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, i18nTexts.allocationOptions[phase].none.helpText)))
}].filter(Boolean);
const DataTierAllocation = props => {
  const styles = useStyles();
  const {
    phase,
    hasNodeAttributes,
    isCloudEnabled,
    isUsingDeprecatedDataRoleConfig,
    isLoading
  } = props;

  /**
   * On Cloud we want to disable the data tier allocation option when we detect that we are not
   * using node roles in our Node config yet. See {@link ListNodesRouteResponse} for information about how this is
   * detected.
   */
  const disableDataTierOption = Boolean(isCloudEnabled && isUsingDeprecatedDataRoleConfig);
  const dataTierAllocationTypePath = `_meta.${phase}.dataTierAllocationType`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: dataTierAllocationTypePath
  });
  const dataTierAllocationType = (0, _lodash.get)(formData, dataTierAllocationTypePath);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${phase}-dataTierAllocationControls`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: dataTierAllocationTypePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, field => {
    /**
     * We reset the value to "custom" if we deserialized to "default".
     *
     * It would be better if we had all the information we needed before deserializing and
     * were able to handle this at the deserialization step instead of patching further down
     * the component tree - this should be a future refactor.
     */
    if (disableDataTierOption && field.value === 'node_roles') {
      field.setValue('node_attrs');
    }
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
      field: field,
      euiFieldProps: {
        isLoading,
        hasDividers: true,
        'data-test-subj': 'dataTierSelect',
        options: getSelectOptions(phase, disableDataTierOption)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 13
      }
    });
  }), dataTierAllocationType === 'node_attrs' && hasNodeAttributes && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.controlSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_node_allocation.NodeAllocation, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  })))));
};
exports.DataTierAllocation = DataTierAllocation;