"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createImageAction = void 0;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _presentationUtil = require("@kbn/presentation-util");
var _constants = require("../../common/constants");
var _kibana_services = require("../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createImageAction = exports.createImageAction = {
  id: _constants.ADD_IMAGE_EMBEDDABLE_ACTION_ID,
  getIconType: () => 'image',
  order: 20,
  isCompatible: async ({
    embeddable: parentApi
  }) => (0, _presentationContainers.apiCanAddNewPanel)(parentApi),
  execute: async ({
    embeddable: parentApi
  }) => {
    if (!(0, _presentationContainers.apiCanAddNewPanel)(parentApi)) throw new _public2.IncompatibleActionError();
    (0, _presentationUtil.openLazyFlyout)({
      core: _kibana_services.coreServices,
      parentApi,
      loadContent: async ({
        closeFlyout,
        ariaLabelledBy
      }) => {
        const {
          getImageEditor
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/image_editor/get_image_editor')));
        return await getImageEditor({
          closeFlyout,
          ariaLabelledBy,
          onSave: imageConfig => {
            parentApi.addNewPanel({
              panelType: _constants.IMAGE_EMBEDDABLE_TYPE,
              serializedState: {
                rawState: {
                  imageConfig
                }
              }
            });
          }
        });
      }
    });
  },
  grouping: [_public.ADD_PANEL_ANNOTATION_GROUP],
  getDisplayName: () => _i18n.i18n.translate('imageEmbeddable.imageEmbeddableFactory.displayName', {
    defaultMessage: 'Image'
  })
};