"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceTemplateStrings = replaceTemplateStrings;
var _mustache = _interopRequireDefault(require("mustache"));
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TEMPLATE_TAGS = ['{', '}'];
// replace template strings without the default mustache escaping
function replaceTemplateStrings(text) {
  const {
    tutorialService,
    kibanaVersion,
    docLinks
  } = (0, _kibana_services.getServices)();
  const variables = {
    // '{' and '}' can not be used in template since they are used as template tags.
    // Must use '{curlyOpen}'' and '{curlyClose}'
    curlyOpen: '{',
    curlyClose: '}',
    config: {
      ...tutorialService.getVariables(),
      docs: {
        base_url: docLinks.ELASTIC_WEBSITE_URL,
        beats: {
          filebeat: docLinks.links.filebeat.base,
          metricbeat: docLinks.links.metricbeat.base,
          heartbeat: docLinks.links.heartbeat.base,
          winlogbeat: docLinks.links.winlogbeat.base,
          auditbeat: docLinks.links.auditbeat.base
        },
        logstash: docLinks.links.logstash.base,
        version: docLinks.DOC_LINK_VERSION
      },
      kibana: {
        version: kibanaVersion
      }
    }
  };
  const config = {
    tags: TEMPLATE_TAGS,
    escape: s => s
  };
  return _mustache.default.render(text, variables, undefined, config);
}