"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceTopNavMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _state_management = require("../../state_management");
var _settings = require("../settings");
var _as_observable = require("../../helpers/as_observable");
var _use_inspector = require("../../helpers/use_inspector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/components/workspace_layout/workspace_top_nav_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WorkspaceTopNavMenu = props => {
  var _props$workspace;
  const store = (0, _reactRedux.useStore)();
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const allSavingDisabled = props.graphSavePolicy === 'none';
  const isInspectDisabled = !((_props$workspace = props.workspace) !== null && _props$workspace !== void 0 && _props$workspace.lastRequest) || !props.workspace.lastRequest;
  const {
    onOpenInspector
  } = (0, _use_inspector.useInspector)({
    inspect: props.inspect,
    requestAdapter: props.requestAdapter
  });

  // ===== Menubar configuration =========
  const {
    TopNavMenu
  } = props.navigation.ui;
  const topNavMenu = [];
  topNavMenu.push({
    key: 'new',
    label: _i18n.i18n.translate('xpack.graph.topNavMenu.newWorkspaceLabel', {
      defaultMessage: 'New'
    }),
    description: _i18n.i18n.translate('xpack.graph.topNavMenu.newWorkspaceAriaLabel', {
      defaultMessage: 'New Workspace'
    }),
    tooltip: _i18n.i18n.translate('xpack.graph.topNavMenu.newWorkspaceTooltip', {
      defaultMessage: 'Create a new workspace'
    }),
    disableButton() {
      return !props.isInitialized;
    },
    run() {
      props.confirmWipeWorkspace(() => {
        if (location.pathname === '/workspace/') {
          history.go(0);
        } else {
          history.push('/workspace/');
        }
      });
    },
    testId: 'graphNewButton'
  });

  // if saving is disabled using uiCapabilities, we don't want to render the save
  // button so it's consistent with all of the other applications
  if (props.capabilities.graph.save) {
    // allSavingDisabled is based on the xpack.graph.savePolicy, we'll maintain this functionality

    topNavMenu.push({
      key: 'save',
      label: _i18n.i18n.translate('xpack.graph.topNavMenu.saveWorkspace.enabledLabel', {
        defaultMessage: 'Save'
      }),
      description: _i18n.i18n.translate('xpack.graph.topNavMenu.saveWorkspace.enabledAriaLabel', {
        defaultMessage: 'Save workspace'
      }),
      tooltip: () => {
        if (allSavingDisabled) {
          return _i18n.i18n.translate('xpack.graph.topNavMenu.saveWorkspace.disabledTooltip', {
            defaultMessage: 'No changes to saved workspaces are permitted by the current save policy'
          });
        } else {
          return _i18n.i18n.translate('xpack.graph.topNavMenu.saveWorkspace.enabledTooltip', {
            defaultMessage: 'Save this workspace'
          });
        }
      },
      disableButton() {
        return allSavingDisabled || !(0, _state_management.hasFieldsSelector)(store.getState());
      },
      run: () => {
        store.dispatch({
          type: 'x-pack/graph/SAVE_WORKSPACE',
          payload: props.savedWorkspace
        });
      },
      testId: 'graphSaveButton'
    });
  }
  topNavMenu.push({
    key: 'inspect',
    disableButton() {
      return isInspectDisabled;
    },
    label: _i18n.i18n.translate('xpack.graph.topNavMenu.inspectLabel', {
      defaultMessage: 'Inspect'
    }),
    description: _i18n.i18n.translate('xpack.graph.topNavMenu.inspectAriaLabel', {
      defaultMessage: 'Inspect'
    }),
    run: () => {
      onOpenInspector();
    },
    tooltip: () => {
      if (isInspectDisabled) {
        return _i18n.i18n.translate('xpack.graph.topNavMenu.inspectButton.disabledTooltip', {
          defaultMessage: 'Perform a search or expand a node to enable Inspect'
        });
      }
    },
    testId: 'graphInspectButton'
  });
  topNavMenu.push({
    key: 'settings',
    disableButton() {
      return (0, _state_management.datasourceSelector)(store.getState()).current.type === 'none';
    },
    label: _i18n.i18n.translate('xpack.graph.topNavMenu.settingsLabel', {
      defaultMessage: 'Settings'
    }),
    description: _i18n.i18n.translate('xpack.graph.topNavMenu.settingsAriaLabel', {
      defaultMessage: 'Settings'
    }),
    run: () => {
      // At this point workspace should be initialized,
      // since settings button will be disabled only if workspace was set
      const workspace = props.workspace;
      const settingsObservable = (0, _as_observable.asSyncedObservable)(() => ({
        blocklistedNodes: workspace.blocklistedNodes,
        unblockNode: workspace.unblockNode,
        unblockAll: workspace.unblockAll,
        canEditDrillDownUrls: props.canEditDrillDownUrls
      }));
      props.coreStart.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: store,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_settings.Settings, {
        observable: settingsObservable,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 13
        }
      })), props.coreStart), {
        size: 'm',
        closeButtonProps: {
          'aria-label': _i18n.i18n.translate('xpack.graph.settings.closeLabel', {
            defaultMessage: 'Close'
          })
        },
        'data-test-subj': 'graphSettingsFlyout',
        ownFocus: true,
        className: 'gphSettingsFlyout',
        maxWidth: 520,
        'aria-label': _i18n.i18n.translate('xpack.graph.settings.ariaLabel', {
          defaultMessage: 'Settings'
        })
      });
    },
    testId: 'graphSettingsButton'
  });
  return /*#__PURE__*/_react.default.createElement(TopNavMenu, {
    appName: "workspacesTopNav",
    config: topNavMenu,
    setMenuMountPoint: props.setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 5
    }
  });
};
exports.WorkspaceTopNavMenu = WorkspaceTopNavMenu;